/* Copyright (C) 1994, Klaus Preschern.                        */
/* All rights reserved.                                        */
/* See the file COPYRIGHT.KP for a full description.           */

#include <std.h>
#include <stdio.h>
#include <fcntl.h>
#include "/ex32/include/sys/message.h"
#include "/ex32/include/sys/grmess.h"

#define BUF_SIZE		4096
#define GRAPHICS_DRIVER		"/ex32/dev/graphics"

static int gr_initialized = 0;
static int gr_handle;
static char trans_buf [BUF_SIZE];

static int get_size (GrMessType gmt)
  {
    int result = -1;
    
    switch (gmt) {
    case m_arc:			result = sizeof (Arc); break;
    case m_bar:			result = sizeof (Bar); break;
    case m_bar3d:		result = sizeof (Bar3d); break;
    case m_circle:		result = sizeof (Circle); break;
    case m_cleardevice:		result = 0; break;
    case m_clearviewport:	result = 0; break;
    case m_closegraph:		result = 0; break;
    case m_detectgraph:		result = sizeof (Detectgraph); break;
    case m_drawpoly:		result = sizeof (Drawpoly); break;
    case m_ellipse:		result = sizeof (Ellipse); break;
    case m_fillellipse:		result = sizeof (Fillellipse); break;
    case m_fillpoly:		result = sizeof (Fillpoly); break;
    case m_floodfill:		result = sizeof (Floodfill); break;
    case m_getarccoords:	result = sizeof (Getarccoords); break;
    case m_getaspectratio:	result = sizeof (Getaspectratio); break;
    case m_getbkcolor:		result = sizeof (Gresult); break;
    case m_getcolor:		result = sizeof (Gresult); break;
    case m_getdefaultpalette:	result = sizeof (Getdefaultpalette); break;
    case m_getdrivername:	result = sizeof (Getdrivername); break;
    case m_getfillpattern:	result = sizeof (Getfillpattern); break;
    case m_getfillsettings:	result = sizeof (Getfillsettings); break;
    case m_getgraphmode:	result = sizeof (Gresult); break;
    case m_getimage:		result = sizeof (Getimage); break;
    case m_getlinesettings:	result = sizeof (Getlinesettings); break;
    case m_getmaxcolor:		result = sizeof (Gresult); break;
    case m_getmaxmode:		result = sizeof (Gresult); break;
    case m_getmaxx:		result = sizeof (Gresult); break;
    case m_getmaxy:		result = sizeof (Gresult); break;
    case m_getmodename:		result = sizeof (Getmodename); break;
    case m_getmoderange:	result = sizeof (Getmoderange); break;
    case m_getpalette:		result = sizeof (Getpalette); break;
    case m_getpalettesize:	result = sizeof (Gresult); break;
    case m_getpixel:		result = sizeof (Getpixel); break;
    case m_gettextsettings:	result = sizeof (Gettextsettings); break;
    case m_getviewsettings:	result = sizeof (Getviewsettings); break;
    case m_getx:		result = sizeof (Gresult); break;
    case m_gety:		result = sizeof (Gresult); break;
    case m_graphdefaults:	result = 0; break;
    case m_grapherrormsg:	result = sizeof (Grapherrormsg); break;
/*	m__graphfreemem,*/
/*	m__graphgetmem,*/
    case m_graphresult:		result = sizeof (Gresult); break;
    case m_imagesize:		result = sizeof (Imagesize); break;
    case m_initgraph:		result = sizeof (Initgraph); break;
/*	m_installuserdriver,*/
/*	m_installuserfont,*/
    case m_line:		result = sizeof (Line); break;
    case m_linerel:		result = sizeof (Linerel); break;
    case m_lineto:		result = sizeof (Lineto); break;
    case m_moverel:		result = sizeof (Moverel); break;
    case m_moveto:		result = sizeof (Moveto); break;
    case m_outtext:		result = sizeof (Outtext); break;
    case m_outtextxy:		result = sizeof (Outtextxy); break;
    case m_pieslice:		result = sizeof (Pieslice); break;
    case m_putimage:		result = sizeof (Putimage); break;
    case m_putpixel:		result = sizeof (Putpixel); break;
    case m_rectangle:		result = sizeof (Rectangle); break;
/*	m_registerbgidriver,*/
/*	m_registerbgifont,*/
    case m_restorecrtmode:	result = 0; break;
    case m_sector:		result = sizeof (Sector); break;
    case m_setactivepage:	result = sizeof (Setactivepage); break;
    case m_setallpalette:	result = sizeof (Setallpalette); break;
    case m_setaspectratio:	result = sizeof (Setaspectratio); break;
    case m_setbkcolor:		result = sizeof (Setbkcolor); break;
    case m_setcolor:		result = sizeof (Setcolor); break;
    case m_setfillpattern:	result = sizeof (Setfillpattern); break;
    case m_setfillstyle:	result = sizeof (Setfillstyle); break;
/*	m_setgraphbufsize,*/	
    case m_setgraphmode:	result = sizeof (Setgraphmode); break;
    case m_setlinestyle:	result = sizeof (Setlinestyle); break;
    case m_setpalette:		result = sizeof (Setpalette); break;
    case m_setrgbpalette:	result = sizeof (Setrgbpalette); break;
    case m_settextjustify:	result = sizeof (Settextjustify); break;
    case m_settextstyle:	result = sizeof (Settextstyle); break;
    case m_setusercharsize:	result = sizeof (Setusercharsize); break;
    case m_setviewport:		result = sizeof (Setviewport); break;
    case m_setvisualpage:	result = sizeof (Setvisualpage); break;
    case m_setwritemode:	result = sizeof (Setwritemode); break;
    case m_textheight:		result = sizeof (Textheight); break;
    case m_textwidth:		result = sizeof (Textwidth); break;
    }
    
    if (result < 0) {
      restorecrtmode ();
      printf ("grmess: illegal graphics message type\n");
      exit (-1);
    }
    if (result == 0) {
      /* It is necessary to call write () with at least 1 (here dummy) byte.
       * Otherwise ex32 will not call the driver !
       */
      result = 1;
    }
    return result;
  }

static void init_graphics ()
  {
    if ((gr_handle = open (GRAPHICS_DRIVER, O_RDONLY, 0)) < 0) {
      fprintf (stderr, "grmess: cannot open graphics device %s\n",
               GRAPHICS_DRIVER);
      exit (-1);
    }
    gr_initialized = 1;
  }

int send_grmess (GrMessType gmt, Graphic_Mess * gm)
  {
    if (! gr_initialized) {
      init_graphics ();
    }
    memcpy (trans_buf, gm, get_size (gmt));
    messsubtype (gmt);
    return write (gr_handle, trans_buf, get_size (gmt));
  }

int recv_grmess (GrMessType gmt, Graphic_Mess * gm)
  {
    int result;

    if (! gr_initialized) {
      init_graphics ();
    }
    messsubtype (gmt);
    result = read (gr_handle, trans_buf, sizeof (*gm));
    memcpy (gm, trans_buf, result);
    return result;
  }

int sendrecv_grmess (GrMessType gmt, Graphic_Mess * gm)
  {
    int result;
    if (! gr_initialized) {
      init_graphics ();
    }
    memcpy (trans_buf, gm, get_size (gmt));
    messsubtype (gmt);
    result = _wrrd (gr_handle, trans_buf, get_size (gmt));
    memcpy (gm, trans_buf, result);
    return result;
  }
