#ifdef __TURBOC__
#include <graphics.h>
#else
#include "/ex32/include/graphics.h"
#endif
#include <stdlib.h>
#include <stdio.h>

/* die Namen der untersttzten Zeichenstze */
char *fname[] = { "DEFAULT_FONT",
                  "TRIPLEX_FONT",
                  "SMALL_FONT",
                  "SANSSERIF_FONT",
                  "GOTHIC_FONT"
                };

int main(void)
{
    /* automatische Erkennung der
       Bildschirmkarte angefordert */
   int gdriver = DETECT, gmode, errorcode;
   int style, midx, midy;
   int size = 1;

   /* Grafik initialisieren */
   initgraph(&gdriver, &gmode, "\\ex32\\lib\\");

   /* Ergebnis der Initialisierung auswerten */
   errorcode = graphresult();
   if (errorcode != grOk)
   {         /* Initialisierung miglckt */
      printf("Grafikfehler: %s\n",
             grapherrormsg(errorcode));
      printf("Drcken Sie eine beliebige "
             "Taste!");
      getchar ();

      exit(1);    /* Ende mit Fehlercode */
   }

   midx = getmaxx() / 2;
   midy = getmaxy() / 2;
   settextjustify(CENTER_TEXT, CENTER_TEXT);
   /* Schleife durch die verfgbaren
      Zeichenstze */
   for (style=DEFAULT_FONT;
        style<=GOTHIC_FONT; style++)
   {
      /* lscht den Grafikbildschirm und stellt
         die Gre ab dem ersten Vektor-
         Zeichensatz auf 4 */
      cleardevice();
      if (style == TRIPLEX_FONT)
         size = 4;

      /* whlt den Zeichensatz */
      settextstyle(style, HORIZ_DIR, size);

      /* gibt eine Meldung aus und
         wartet auf einen Tastendruck */
      outtextxy(midx, midy, fname[style]);
      getchar ();
   }

   /* Grafikmodus beenden */
   closegraph();
   return 0;
}
