INTERFACE BasePageHandle;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.4 $
    $Date: 1999/07/21 18:55:19 $
    $Log: BasePageHandle.i3,v $
    Revision 1.4  1999/07/21 18:55:19  hosking
    Added getPage to be more consistent.  Dropped accessPage.

    Revision 1.3  1999/05/27 02:11:18  hosking
    Added accessPage method.

    Revision 1.2  1999/04/28 15:12:31  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:40  hosking
    Import of GRAS3-1.1

    Revision 1.3  1996/03/06 14:00:55  rbnix
    	New method fmt added to get a formatted representation of the
    	handle's value.

    Revision 1.2  1996/02/29 17:40:00  rbnix
    	New methods getAll and copyData added.

    Revision 1.1  1996/01/31 10:04:28  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- BasePageHandle -----------------------------------------------------
 * This abstract data type represents an access path to a temporary load
 * page. Changes can be recognized due to write access is monitored.
 * ------------------------------------------------------------------------
 *)

IMPORT
  Page,
  PageData;


TYPE
  T                     <: Public;

  Public		= Private OBJECT
    METHODS
      isLoad            () :BOOLEAN;

      isChanged		() :BOOLEAN;
      markChanged	();
      unmarkChanges	();

      getPage		() :Page.T;

      putData           (READONLY data		:PageData.Part;
			          pos		:= FIRST (PageData.Index);
                                  transform     :PageData.Transform := NIL);

      getData           (VAR      data		:PageData.Part;
			          pos		:= FIRST (PageData.Index));

      getAll            (VAR      data          :PageData.T);

      copyData		(         source	:PageData.Index;
                                  destination	:PageData.Index;
                                  length	:PageData.Index);

      fmt		() :TEXT;
    END;

  Private		<: <*TRANSIENT*> ROOT;


END BasePageHandle.
