MODULE DumpMedia;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:32 $
    $Log: DumpMedia.m3,v $
    Revision 1.2  1999/04/28 15:12:32  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:41  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/01/31 10:04:34  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

FROM Stdio IMPORT stdout;
IMPORT
  Thread, Wr, Fmt,
  PageHandle,
  PageData;

<* FATAL Thread.Alerted, Wr.Failure *>

REVEAL
  T                     = Public BRANDED OBJECT
    OVERRIDES
      loadData		:= LoadData;
      dropData		:= DropData;
    END;


PROCEDURE LoadData      (         <* UNUSED *>
				  self            :T;
                                  handle          :PageHandle.T;
                                  <* UNUSED *>
                         VAR      data            :PageData.T) =
  BEGIN
    Wr.PutText (stdout,
                "DummyMedia.LoadData (" &
                Fmt.Int (handle.getPageNo ()) &
                ")\n");
  END LoadData;

  
PROCEDURE DropData      (         <* UNUSED *>
				  self		  :T;
                                  handle          :PageHandle.T;
                                  <* UNUSED *>
                         READONLY data            :PageData.T) =
  BEGIN
    Wr.PutText (stdout,
                "DummyMedia.DropPage (" &
                Fmt.Int (handle.getPageNo ()) &
                ", changed = " &
                Fmt.Bool (handle.isChanged ()) &
                ")\n");
  END DropData;


BEGIN
END DumpMedia.
