INTERFACE InternalObjectListItem;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:41 $
    $Log: InternalObjectListItem.i3,v $
    Revision 1.1.1.1  1998/12/03 18:53:41  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/01/31 10:04:36  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- InternalObjectListItem ---------------------------------------------
 * Subsystem internal interface to an list item.
 *
 * List items are related to a list by chaining variables stored at the
 * list items itself.
 * ------------------------------------------------------------------------
 *)

IMPORT
  BaseObjectList, ObjectListItem;

REVEAL
  ObjectListItem.T	<: Internal;

TYPE
  Internal		= ObjectListItem.Public OBJECT
    METHODS
      setNext		(        next		:ObjectListItem.T);
      getNext		() :ObjectListItem.T;

      setPrev		(        prev		:ObjectListItem.T);
      getPrev		() :ObjectListItem.T;

      setList		(        list		:BaseObjectList.T);
    END;

END InternalObjectListItem.
