INTERFACE InternalPageCache;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:32 $
    $Log: InternalPageCache.i3,v $
    Revision 1.2  1999/04/28 15:12:32  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:41  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/01/31 10:04:38  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- InternalPageCache --------------------------------------------------
 * This interface extends the public one for subsystem internal use only.
 *
 * It gives access to the page replacement strategy and should therefore
 * used only by PageHandle to view transparent swapping behaviour outside.
 *
 * The function AtomicAccess may be used to assert non atomic cache use.
 * ------------------------------------------------------------------------
 *)

IMPORT
  PageHandle;


<* PRAGMA SPEC *>

PROCEDURE LoadPage	(        handle		:PageHandle.T);
  <*
    SPEC
    REQUIRES cacheUser = CURRENT
  *>

PROCEDURE AssignPage	(        handle		:PageHandle.T);
  <*
    SPEC
    REQUIRES cacheUser = CURRENT
  *>

PROCEDURE RecognizeAccess (      handle		:PageHandle.T);
  <*
    SPEC
    REQUIRES cacheUser = CURRENT
  *>
    

END InternalPageCache.
