INTERFACE PageMedia;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:34 $
    $Log: PageMedia.i3,v $
    Revision 1.2  1999/04/28 15:12:34  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:43  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/01/31 10:04:53  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- PageMedia ----------------------------------------------------------
 * The abstract data type PageMedia specifies an interface to a (persistent)
 * storage media for page data.
 *
 * The data is transfered between the media and the page via it's handle
 * by access methods of the media working as specified below.
 * ------------------------------------------------------------------------
 *)

IMPORT BasePageMedia AS Super;
IMPORT
  PageHandle,
  PageData;


<* PRAGMA SPEC *>

<*
   SPEC
   PRIVATE VAR storage :ARRAY OF PageData
*>


TYPE
  T                     = Super.T OBJECT
    METHODS
      loadData		(         handle         :PageHandle.T;
                         VAR      data           :PageData.T) := NIL;
        <*
          SPEC
          MODIFIES data
          ENSURES data' = storage[handle.pageNo]
        *>

      dropData		(         handle         :PageHandle.T;
                         READONLY data           :PageData.T) := NIL;
        <*
          SPEC
          REQUIRES handle.isChanged <==> (data # storage[handle.pageNo])
          MODIFIES storage[handle.pageNo]
          ENSURES storage[handle.pageNo]' = data
        *>
    END;
      

END PageMedia.
