MODULE NumberedPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:45 $
    $Log: NumberedPage.m3,v $
    Revision 1.1.1.1  1998/12/03 18:53:45  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/10/07 13:31:44  rbnix
    	New module for numbered pages.

*)
(***************************************************************************)
IMPORT
  PageData;


REVEAL
  T			= Public BRANDED OBJECT
      number		:CARDINAL;

    OVERRIDES
      init		:= Init;
      getNumber		:= GetNumber;
    END;


PROCEDURE Init		(         self		:T;
                                  number	:CARDINAL;
                         READONLY data		:PageData.T)
			:T =
  BEGIN
    self.number := number;
    self.putData (data);

    RETURN self;
  END Init;


PROCEDURE GetNumber	(         self		:T)
			:CARDINAL =
  BEGIN
    RETURN self.number;
  END GetNumber;


BEGIN
END NumberedPage.
