INTERFACE PageFileSystem;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/07/07 22:48:54 $
    $Log: PageFileSystem.i3,v $
    Revision 1.2  1999/07/07 22:48:54  hosking
    Changed Pathname.Arcs to be TextTransientSeq instead of TextSeq, to fix
    problem with GRAS3 page client.

    Revision 1.1.1.1  1998/12/03 18:53:45  hosking
    Import of GRAS3-1.1

    Revision 1.3  1997/03/26 11:19:25  roland
    New procedure MakePath creates a directory and additionally all
    necessary ancestors.

    Revision 1.2  1996/08/06 16:26:09  roland
    Merge of PAGESERVER and main branch.

    Revision 1.1.2.1  1996/07/25 11:49:21  rbnix
    	First version of module PageFileSystem added.

*)
(***************************************************************************)
(*
 | --- PageFileSystem -----------------------------------------------------
 This abstract data type module provides some basic functionality on files.
 | ------------------------------------------------------------------------
 *)
IMPORT
  Pathname, TextTransientSeq AS TextSeq,
  PageFile;


(* file support *)
PROCEDURE DeleteFile		(         name		:Pathname.T)
				RAISES {PageFile.NoAccess};

PROCEDURE CopyFile		(         sourceName,
                                          destName	:Pathname.T)
				RAISES {PageFile.NoAccess};

PROCEDURE RenameFile		(         oldName,
                                          newName	:Pathname.T)
				RAISES {PageFile.NoAccess};

PROCEDURE ExistsFile		(         name		:Pathname.T)
				:BOOLEAN;

PROCEDURE FileSize		(         name		:Pathname.T)
				:CARDINAL
				RAISES {PageFile.NoAccess};
  (*
    Returns the file size as number of data pages.
  *)


(* directory support *)
PROCEDURE MakeDir		(         name		:Pathname.T)
				RAISES {PageFile.NoAccess};
  (* Try to create a directory 'name'. Parents have to exist *)

PROCEDURE MakePath		(         name		:Pathname.T)
				RAISES {PageFile.NoAccess};
  (* Try to create a directory 'name'. If parents of name do not exists,
     try to create them. *)

PROCEDURE RemoveDir		(         name		:Pathname.T)
				RAISES {PageFile.NoAccess};

PROCEDURE ExistsDir		(         name		:Pathname.T)
				:BOOLEAN;


PROCEDURE GetFileNames		(         dirName	:Pathname.T)
				:TextSeq.T 
				RAISES {PageFile.NoAccess};

PROCEDURE GetDirNames		(         dirName	:Pathname.T)
				:TextSeq.T 
				RAISES {PageFile.NoAccess};


END PageFileSystem.
