INTERFACE GraphActiveAction;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:08 $
    $Log: GraphActiveAction.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:08  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/11/12 15:23:53  roland
    Specialized event handler subsystem for PersistentGraphs
    introduced. Events on edges and attributes depend on their nodes, so
    that events might not be delivered, when their nodes are deleted in
    the meantime.

*)
(***************************************************************************)

IMPORT Action, Event, ContextSet;

CONST Brand = "ActiveAction";

TYPE
  Struct =
    RECORD
      priority              : PriorityType;
      action                : Action.T;
      depsFirst, depsTarg   : BOOLEAN;
      event                 : Event.T;
      context               : ContextSet.T;
      userdata              : REFANY;
      level                 : CARDINAL;
      deleted               : BOOLEAN;
      nextClient, prevClient: T;
      nextLevel, prevLevel  : T;
    END;

  T = REF Struct;

  PriorityType = RECORD prio, timeStamp: CARDINAL END;

PROCEDURE PrioLess (p1, p2: PriorityType): BOOLEAN;
PROCEDURE Priority (act: T): PriorityType;

END GraphActiveAction.
