INTERFACE InternalScheduledClientPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: chenj $
    $Revision: 1.2 $
    $Date: 1999/07/08 23:02:47 $
    $Log: InternalScheduledClientPage.i3,v $
    Revision 1.2  1999/07/08 23:02:47  chenj
    Add chain transaction.

    Revision 1.1.1.1  1998/12/03 18:54:22  hosking
    Import of GRAS3-1.1

    Revision 1.4  1996/11/18 17:51:43  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.3  1996/10/29 15:01:43  rbnix
    	New parameter for page age added.

    Revision 1.2  1996/03/11 17:18:32  rbnix
    	Method close added to return cached locks.

    Revision 1.1  1996/02/09 16:46:47  rbnix
    	First version of client scheduler added.

*)
(***************************************************************************)

(*
 | --- InternalScheduledClientPage ----------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  Page,
  PageHandle,
  PageLock, Access,
  ScheduledClientPage, BaseScheduledClientFile,
  CallbackPort;

REVEAL
  ScheduledClientPage.T	<: Internal;

TYPE
  Internal		= ScheduledClientPage.Public OBJECT
    METHODS
      init		(         scheduledFile	:BaseScheduledClientFile.T;
                                  pageNo	:CARDINAL)
			:ScheduledClientPage.T;

      close		() RAISES {ScheduledClientPage.FatalError};
      commitTransaction	() RAISES {ScheduledClientPage.FatalError};
      chainTransaction	() RAISES {ScheduledClientPage.FatalError};
      abortTransaction	() RAISES {ScheduledClientPage.FatalError};

      releaseCallback	(         pageAge	:CARDINAL;
                                  lock		:PageLock.CallbackMode)
			RAISES {Access.Locked, CallbackPort.FatalError};
      propagateCallback	(         pageAge	:CARDINAL;
                                  lock		:PageLock.CallbackMode;
                                  page		:Page.T)
      RAISES {CallbackPort.FatalError};

      dropData		(         handle	:PageHandle.T)
      RAISES {ScheduledClientPage.FatalError};
    END;


END InternalScheduledClientPage.
