INTERFACE LocalResourceSystem;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:22 $
    $Log: LocalResourceSystem.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:22  hosking
    Import of GRAS3-1.1

    Revision 1.1  1998/02/10 16:36:28  roland
    LocalResourceSystem offers procedures to manage the local part of
    resources.

*)
(***************************************************************************)

IMPORT Pathname;
IMPORT PageFile;

PROCEDURE DeleteLocalResource (baseName: Pathname.T)
  RAISES {PageFile.NoAccess};

PROCEDURE CopyLocalResource (sourceName: Pathname.T; destName: Pathname.T)
  RAISES {PageFile.NoAccess};

PROCEDURE RenameLocalResource (oldName: Pathname.T; newName: Pathname.T)
  RAISES {PageFile.NoAccess};

PROCEDURE ExistsLocalResource (baseName: Pathname.T): BOOLEAN
  RAISES {PageFile.NoAccess};


END LocalResourceSystem.
