MODULE VirtualPageEventPattern;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:12:53 $
    $Log: VirtualPageEventPattern.m3,v $
    Revision 1.2  1999/04/28 15:12:53  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:24  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:14:20  roland
    Subsystem introduces event and pattern types for virtual resources.

*)
(***************************************************************************)

IMPORT EventPattern, VirtualPageEvent, Txn, EventType;
FROM EventType IMPORT Mismatch, Unknown;
FROM PrivateVirtualPageEvent IMPORT TypeNumber, TypeToOp, Resource,
                                    ResourceName, Level, IsPre;

PROCEDURE Create (op: VirtualPageEvent.Operation): T =
  <* FATAL EventType.Unknown *>
  BEGIN
    RETURN NEW(EventPattern.T).init(TypeNumber[op]);
  END Create;

(* Updates to pattern attributes *)
PROCEDURE SetResourceName (p: T; name: TEXT) RAISES {Mismatch, Unknown} =
  VAR opno: INTEGER;
  BEGIN
    IF NOT TypeToOp.get(p.type(), opno) THEN
      RAISE Unknown;
    ELSE
      p.setTextAttribute(
        ResourceName[VAL(opno, VirtualPageEvent.Operation)], name);
    END;
  END SetResourceName;

PROCEDURE SetPreEvent (p: T; ispre: BOOLEAN) RAISES {Mismatch, Unknown} =
  VAR opno: INTEGER;
  BEGIN
    IF NOT TypeToOp.get(p.type(), opno) THEN
      RAISE Unknown;
    ELSIF VAL(opno, VirtualPageEvent.Operation)
            = VirtualPageEvent.Operation.RemoteCommit THEN
      RAISE Unknown
    ELSE
      p.setBoolAttribute(
        IsPre[VAL(opno, VirtualPageEvent.Operation)], ispre);
    END;
  END SetPreEvent;

PROCEDURE SetLevel (p: T; level: Txn.Level)
  RAISES {Mismatch, Unknown} =
  VAR opno: INTEGER;
  BEGIN
    IF NOT TypeToOp.get(p.type(), opno) THEN
      RAISE Unknown;
    ELSIF VAL(opno, VirtualPageEvent.Operation)
            = VirtualPageEvent.Operation.RemoteCommit THEN
      RAISE Unknown
    ELSE
      p.setIntAttribute(
        Level[VAL(opno, VirtualPageEvent.Operation)], level);
    END;
  END SetLevel;

PROCEDURE SetResource (p: T; resource: REFANY) RAISES {Mismatch, Unknown} =
  VAR opno: INTEGER;
  BEGIN
    IF NOT TypeToOp.get(p.type(), opno) THEN
      RAISE Unknown;
    ELSE
      p.setRefAnyAttribute(
        Resource[VAL(opno, VirtualPageEvent.Operation)], resource);
    END;
  END SetResource;


(* Queries for pattern attributes. *)
PROCEDURE GetResourceName (p: T): TEXT RAISES {Mismatch, Unknown} =
  BEGIN
    RETURN VirtualPageEvent.GetResourceName(p);
  END GetResourceName;

PROCEDURE GetOperation (p: T): VirtualPageEvent.Operation
  RAISES {Unknown} =
  BEGIN
    RETURN VirtualPageEvent.GetOperation(p);
  END GetOperation;

PROCEDURE GetIsPreEvent (p: T): BOOLEAN RAISES {Mismatch, Unknown} =
  BEGIN
    RETURN VirtualPageEvent.GetIsPreEvent(p);
  END GetIsPreEvent;

PROCEDURE GetLevel (p: T): Txn.Level RAISES {Mismatch, Unknown} =
  BEGIN
    RETURN VirtualPageEvent.GetLevel(p);
  END GetLevel;

PROCEDURE GetResource (p: T): REFANY RAISES {Mismatch, Unknown} =
  BEGIN
    RETURN VirtualPageEvent.GetResource(p);
  END GetResource;

BEGIN
END VirtualPageEventPattern.
