MODULE VirtualLocalPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/05/27 02:22:17 $
    $Log: VirtualLocalPage.m3,v $
    Revision 1.2  1999/05/27 02:22:17  hosking
    Changed signature of writeAccess to indicate if page needs loading from server
    or not (in case of write to entire page); this avoids installation reads from
    server.

    Revision 1.1.1.1  1998/12/03 18:54:25  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/02/29 17:44:22  rbnix
    	First version of subsystem VirtualPages giving transparent
    	access to local/remote files/pages.

*)
(***************************************************************************)
(*
 | --- VirtualLocalPage ---------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  PageHandle, PageMedia, PageCache,
  InternalVirtualPage;


REVEAL
  T			= Public BRANDED OBJECT
      handle		:PageHandle.T;

    OVERRIDES
      init		:= Init;
      readAccess	:= ReadAccess;
      writeAccess	:= WriteAccess;
    END;


PROCEDURE Init		(         self		:T;
                                  pageNo	:CARDINAL;
                                  media		:PageMedia.T)
			:T =
  BEGIN
    self.handle := PageCache.GetPage (pageNo, media);

    RETURN self;
  END Init;


PROCEDURE ReadAccess	(         self		:T)
			:PageHandle.T =
  BEGIN
    RETURN self.handle
  END ReadAccess;


PROCEDURE WriteAccess	(         self		:T;
                         <*UNUSED*>
                                  load           :BOOLEAN)
			:PageHandle.T =
  BEGIN
    RETURN self.handle
  END WriteAccess;


BEGIN
END VirtualLocalPage.
