(*!  DATA TYPE MODULE *)
INTERFACE Action;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:11 $
    $Log: Action.i3,v $
    Revision 1.2  1999/04/28 15:13:11  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:35  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:06:09  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. RuleTypes and EventTypes
    subsystems implement basic types of the rule engine.

*)
(***************************************************************************)

IMPORT Event, ContextSet;

TYPE
  Procedure = PROCEDURE (e       : Event.T;
                         context : ContextSet.T;
                         local   : BOOLEAN;
                         userdata: <*TRANSIENT*> REFANY        );

TYPE
  T = <*TRANSIENT*> ROOT OBJECT METHODS client (): CARDINAL END;

  Local <: T OBJECT
           METHODS
             init (proc: Procedure): Local;
             proc (): Procedure;
           END;

  Remote <: T OBJECT
            METHODS
              init (client, trig: CARDINAL): Remote;
              trig (): CARDINAL;
            END;
END Action.
