(*!  DATA TYPE MODULE *)
INTERFACE Event;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:12 $
    $Log: Event.i3,v $
    Revision 1.2  1999/04/28 15:13:12  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:35  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:06:17  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. RuleTypes and EventTypes
    subsystems implement basic types of the rule engine.

*)
(***************************************************************************)

IMPORT EventType;

TYPE
  T <: Public;

  Public =
    <*TRANSIENT*> ROOT OBJECT
    METHODS
      init (type: CARDINAL): T RAISES {EventType.Unknown};
            (* The type number is resolved with EventTypes.Get *)

      type (): CARDINAL;

      setBoolAttribute (index: CARDINAL; val: BOOLEAN)
                        RAISES {EventType.Unknown, EventType.Mismatch};
      setIntAttribute (index: CARDINAL; val: INTEGER)
                       RAISES {EventType.Unknown, EventType.Mismatch};
      setTextAttribute (index: CARDINAL; val: TEXT)
                        RAISES {EventType.Unknown, EventType.Mismatch};
      setRefAnyAttribute (index: CARDINAL; val: REFANY)
                          RAISES {EventType.Unknown, EventType.Mismatch};

      getBoolAttribute (index: CARDINAL): BOOLEAN
                        RAISES {EventType.Unknown, EventType.Mismatch};
      getIntAttribute (index: CARDINAL): INTEGER
                       RAISES {EventType.Unknown, EventType.Mismatch};
      getTextAttribute (index: CARDINAL): TEXT
                        RAISES {EventType.Unknown, EventType.Mismatch};
      getRefAnyAttribute (index: CARDINAL): REFANY
                          RAISES {EventType.Unknown, EventType.Mismatch};
    END;

END Event.
