INTERFACE BrowserConfiguration;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:50 $
    $Log: BrowserConfiguration.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:50  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/06/06 14:24:36  roland
    Some runtime configuration support added. A file-name can be given as
    command line parameter with '-config'. From this file the collection
    name and representation types for names attributes will be read.

*)
(***************************************************************************)

IMPORT Rd, Wr;

TYPE AttributeFormat = {NonReadableText, ReadableText, Integer, Cardinal};

PROCEDURE ReadConfiguration(rd: Rd.T);
PROCEDURE WriteConfiguration(wr: Wr.T);

PROCEDURE GetCollectionName(): TEXT;
PROCEDURE SetCollectionName(name: TEXT);

PROCEDURE SetAttributeFormat(attr: TEXT; format: AttributeFormat);
PROCEDURE GetAttributeFormat(attr: TEXT): AttributeFormat;
PROCEDURE FormatAttribute(attr, val: TEXT): TEXT;
  
END BrowserConfiguration.
