INTERFACE RGRASNames;

(***************************************************************************)
(** Created by:  Rene Huelswitt						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:58 $
    $Log: RGRASNames.i3,v $
    Revision 1.1.1.1  1998/12/03 18:54:58  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/24 14:39:13  renehuel
    These files implement the new RGRASGraph interface.

*)
(***************************************************************************)

IMPORT AtomList, Access, ChgMgmtGraphPool, Pathname, Names;
IMPORT TypedNames AS Super;

TYPE
  T <: Public;
  Public =
    Super.T OBJECT
    METHODS
      login (pool: ChgMgmtGraphPool.T; collection: Pathname.T)
             RAISES {InternalError, Access.Locked};
      getUniqueId (): CARDINAL RAISES {InternalError, Access.Locked,
                                       Names.Undeclared, Names.Unknown};
    END;

EXCEPTION InternalError(AtomList.T);
END RGRASNames.
