MODULE BaseAssembly;

IMPORT OO7, OO7Rep, PartIdSet, Globals, CRandom, GenParams, VarParams,
       Assembly, BaseAssemblyList, CompositePartList;
FROM IO IMPORT Put, PutInt;
FROM Support IMPORT PrintOp;

REVEAL T = OO7.BaseAssembly BRANDED "BaseAssembly.T" OBJECT
OVERRIDES
  traverse := Traverse;
  traverse7 := Traverse7;
  mytype := Type;
  doNothing := Assembly.DoNothing;
  init := Init;
END;

PROCEDURE Init (self: T; asId: INTEGER; module: OO7.Module;
                parentAssembly: OO7.ComplexAssembly): OO7.BaseAssembly =
  VAR
    compId: INTEGER;
    lowCompId: INTEGER;
    compIdLimit: INTEGER;
  BEGIN
    IF Globals.debugMode THEN
      Put("BaseAssembly::BaseAssembly(asId = "); PutInt(asId);
      Put(", levelNo = "); PutInt(VarParams.NumAssmLevels); Put(")\n");
    END;

    (* initialize the simple stuff *)
    self.id := asId;
    VAR typeNo := CRandom.random() MOD GenParams.NumTypes;
    BEGIN self.type := Globals.types[typeNo]; END;
    self.buildDate :=
        GenParams.MinAssmDate +
        (CRandom.random() MOD (GenParams.MaxAssmDate-GenParams.MinAssmDate+1));
    self.superAssembly := parentAssembly;
    self.assmType := OO7.AssemblyType.Base;

    (* add the base assembly to the extent of all base assemblies in this
       module *)
    module.allBases := BaseAssemblyList.Cons(self, module.allBases);
    
    (* get access to the design library containing composite parts *)
    lowCompId := (module.id - 1) * VarParams.NumCompPerModule + 1;
    compIdLimit := VarParams.NumCompPerModule;

    (* first select the private composite parts for this assembly *)
    FOR i := 0 TO VarParams.NumCompPerAssm - 1 DO
      compId := lowCompId + (CRandom.random() MOD compIdLimit);
      (* keep track of which composite parts this base assembly uses as
         private *)
      Globals.private_cp[compId] :=
          BaseAssemblyList.Cons(self, Globals.private_cp[compId]);
    END;

    (* next select the shared composite parts for this assembly *)
    FOR i := 0 TO VarParams.NumCompPerAssm - 1 DO
      compId := (CRandom.random() MOD VarParams.TotalCompParts) + 1;
      (* keep track of which composite parts this base assembly uses as
         shared *)
      Globals.shared_cp[compId] :=
          BaseAssemblyList.Cons(self, Globals.shared_cp[compId]);
    END;
    RETURN self; 
  END Init;

PROCEDURE Traverse (self: T; op: OO7.BenchmarkOp): INTEGER =
  BEGIN
    IF Globals.debugMode THEN
      Put("\t\tBaseAssembly::traverse(id = "); PutInt(self.id);
      Put(", op = "); PrintOp(op); Put(")\n");
    END;

    VAR
      count := 0;
      cp: CompositePartList.T := self.componentsPriv;
    BEGIN
      WHILE cp # NIL DO
        INC(count, cp.head.traverse(op));
        cp := cp.tail;
      END;
      RETURN count;
    END; 
  END Traverse;

PROCEDURE Traverse7 (self: T; visitedComplexIds: PartIdSet.T): INTEGER =
  BEGIN
    IF Globals.debugMode THEN
      Put("\t\tBaseAssembly::traverse7(id = "); PutInt(self.id); Put(")\n");
    END;

    (* visit this assembly and move on up the design hierarchy *)
    VAR count := 1;
    BEGIN
      self.doNothing();
      IF NOT visitedComplexIds.contains(self.superAssembly.id) THEN
        INC(count, self.superAssembly.traverse7(visitedComplexIds));
      END;
      RETURN count;
    END;
  END Traverse7;

PROCEDURE Type (<*UNUSED*> self: T): OO7.AssemblyType =
  BEGIN
    RETURN OO7.AssemblyType.Base;
  END Type;

BEGIN
END BaseAssembly.
