(* Copyright (C) 1998, Purdue Research Foundation            *)
(* All rights reserved.                                      *)
(* See the file COPYRIGHT for a full description.            *)

INTERFACE RTDB;

FROM RTHeapDep IMPORT Page;
IMPORT Fingerprint;

TYPE
  LockMode = { READ, UPGRADE, WRITE };
  T = <*TRANSIENT*> ROOT OBJECT
    <*TRANSIENT*> root: REFANY
  METHODS
    map(READONLY p: Page; n: CARDINAL): Page;
    unmap(READONLY p: Page);
    pin(p: Page; load := TRUE): ADDRESS;
    unpin(p: Page);
    createRoot();
    lock(READONLY p: Page; mode: LockMode);
    newPages(p: Page; n: CARDINAL): Page;
    getFP(fp: UNTRACED REF Fingerprint.T): REF Fingerprint.T;
    text(t: TEXT): TEXT;
  END;

PROCEDURE RefPageMap(object: REFANY; VAR db: T; VAR p: Page): BOOLEAN;

PROCEDURE Invalidate();
PROCEDURE Release();
PROCEDURE Flush(db: T := NIL): BOOLEAN;
PROCEDURE SwizzleRoot(db: T): ADDRESS;

PROCEDURE Map(db: T; p: Page; n: CARDINAL): Page;

END RTDB.
