INTERFACE PageData;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.3 $
    $Date: 2001/04/04 19:18:07 $
    $Log: PageData.i3,v $
    Revision 1.3  2001/04/04 19:18:07  hosking
    Replaced Transform with Swizzler/Unswizzler.

    Revision 1.2  1999/04/28 15:12:30  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:53:39  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/01/31 10:02:12  rbnix
    	Initial version for subsystem Page.

*)
(***************************************************************************)

(*
 * --- PageData -----------------------------------------------------------
 * This concrete data type module contains common information about
 * data residing on pages.
 * ------------------------------------------------------------------------
 *)

IMPORT Type, RTHeapDep;


CONST
  Size			= RTHeapDep.BytesPerPage; (* no of items in a page *)


TYPE
  Index			= [1 .. Size];		(* index range of items	*)
  Item			= Type.Byte;		(* atomic data item	*)
  Part                  = ARRAY OF Item;	(* some data items	*)
  Swizzler		= PROCEDURE(READONLY data: T);
  Unswizzler		= PROCEDURE(VAR data: T);

  T			= ARRAY Index OF Item;	(* page data		*)


END PageData.
