INTERFACE InternalBasePageHandle;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/07/21 18:56:19 $
    $Log: InternalBasePageHandle.i3,v $
    Revision 1.2  1999/07/21 18:56:19  hosking
    Moved getPage to public interface BasePageHandle.i3.

    Revision 1.1.1.1  1998/12/03 18:53:41  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/03/08 10:29:47  rbnix
    	PageHandles are now tagged by an internal id. Therefore the
    	method init is introduced and the method fmt is enhanced.

    Revision 1.1  1996/01/31 10:04:35  rbnix
    	Initial version for subsystem PageCache.

*)
(***************************************************************************)

(*
 * --- InternalBasePageHandle ---------------------------------------------
 * This interface gives an extended view on BasePageHandle for
 * subsystem use only. The extended view allows changing the related page.
 * ------------------------------------------------------------------------
 *)

IMPORT
  Page,
  ObjectListItem,
  BasePageHandle;

REVEAL
  BasePageHandle.Private= ObjectListItem.T BRANDED OBJECT
    END;

  BasePageHandle.T	<: Internal;

TYPE
  Internal              = BasePageHandle.Public OBJECT
    METHODS
      init		() :BasePageHandle.T;

      setPage		(        page		:Page.T);
    END;

  
END InternalBasePageHandle.
