INTERFACE SimpleMedia;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:44 $
    $Log: SimpleMedia.i3,v $
    Revision 1.1.1.1  1998/12/03 18:53:44  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/02/09 16:39:29  rbnix
    	First version of a new PageMedia added.

    	SimpleMedia represents a media transfering pages between the
    	cache and a simple flat file.

*)
(***************************************************************************)

(*
 | --- SimpleMedia --------------------------------------------------------
 This abstract data type uses a simple PageFile as paging media.
 | ------------------------------------------------------------------------
 *)

IMPORT PageMedia AS Super;
IMPORT
  PageFile;


TYPE
  T			<: Public;

  Public		= Super.T OBJECT
    METHODS
      init		(         file		:PageFile.T) :T;

      getFile		() :PageFile.T;
    END;
  

END SimpleMedia.
