INTERFACE BufferedPageFile;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:44 $
    $Log: BufferedPageFile.i3,v $
    Revision 1.1.1.1  1998/12/03 18:53:44  hosking
    Import of GRAS3-1.1

    Revision 1.1  1996/10/07 13:32:57  rbnix
    	New module for a asynchronous buffered file.

*)
(***************************************************************************)
(*
 | --- BufferedPageFile ---------------------------------------------------
 This abstract data type represents a specialized PageFile where the access
 operations work asynchronous. It is assured that put data will be stored
 in a way sequentialized by flush operations (not neccessarily between
 them). Regard that flush operations are now used to order the data
 transfer not more.
 | ------------------------------------------------------------------------
 *)

IMPORT PageFile AS Super;

TYPE
  T			<: Public;

  Public		= Super.T OBJECT
      (* nothing more *)
    END;

END BufferedPageFile.
