MODULE LogContexts;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:53:56 $
    $Log: LogContexts.m3,v $
    Revision 1.1.1.1  1998/12/03 18:53:56  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/12/02 17:56:38  roland
    New event types and event contexts for user recovery operations
    introduced.

*)
(***************************************************************************)

IMPORT RuleEngine, ContextSet;

VAR context: ARRAY Context OF ContextSet.Index;

PROCEDURE Set(unit: CARDINAL; c: Context) =
  BEGIN
    RuleEngine.ActivateContext(unit, context[c]);
  END Set;
    
PROCEDURE Clear(unit: CARDINAL; c: Context) =
  BEGIN
    RuleEngine.DeactivateContext(unit, context[c]);
  END Clear; 
    
BEGIN
  (* declare contexts to RuleEngine *)
  FOR c := FIRST(Context) TO LAST(Context) DO
    context[c] := ContextSet.DeclareContext(Names[c]);
  END;
END LogContexts.
