MODULE ClientLockEntry;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.1.1.1 $
    $Date: 1998/12/03 18:54:21 $
    $Log: ClientLockEntry.m3,v $
    Revision 1.1.1.1  1998/12/03 18:54:21  hosking
    Import of GRAS3-1.1

    Revision 1.2  1996/03/06 16:11:29  rbnix
    	Journal output improved.

    Revision 1.1  1996/03/06 14:02:58  rbnix
    	New function Fmt added to get a formatted representation of the
    	lock entry's value.

*)
(***************************************************************************)
IMPORT
  PageLock;


PROCEDURE Fmt		(         entry		:T) :TEXT =
  VAR
    handleText		:TEXT;
  BEGIN
    IF entry.handle = NIL THEN
      handleText := "NIL";
    ELSE
      handleText := "(" & entry.handle.fmt () & ")";
    END;

    RETURN "lock = " & PageLock.FmtMode (entry.lock) & ", handle = " & handleText;
  END Fmt;


BEGIN
END ClientLockEntry.
