INTERFACE VirtualPage;

(***************************************************************************)
(** Created by:  Reiner Nix						   *)

(** $Author: hosking $
    $Revision: 1.6 $
    $Date: 2001/04/04 19:25:18 $
    $Log: VirtualPage.i3,v $
    Revision 1.6  2001/04/04 19:25:18  hosking
    putAll/getAll/peekAll now use Swizzler/Unswizzler based interface.

    Revision 1.5  2000/05/26 20:11:04  hosking
    New RTDB.i3 doesn't need pin/unpin.

    Revision 1.4  1999/07/07 22:51:56  hosking
    Removed lock method.

    Revision 1.3  1999/05/27 02:22:48  hosking
    Changed signature of pin to load on default.

    Revision 1.2  1999/04/28 15:12:55  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:25  hosking
    Import of GRAS3-1.1

    Revision 1.5  1997/11/19 17:59:43  roland
    Removed grouping of page accesses.

    Revision 1.4  1997/09/18 08:23:32  roland
    Grouping of access to the same page.

    Revision 1.3  1996/12/03 09:49:24  roland
    Replaced Type.Triple with CARDINAL. Special handling in put/getTriple
    of VirtualPage.

    Revision 1.2  1996/11/18 17:52:21  roland
    ASSERTs and FATALs (mostly) replaced by exception handling.

    Revision 1.1  1996/02/29 17:44:24  rbnix
    	First version of subsystem VirtualPages giving transparent
    	access to local/remote files/pages.

*)
(***************************************************************************)
(*
 | --- VirtualPage --------------------------------------------------------
  
 | ------------------------------------------------------------------------
 *)
IMPORT
  Type,
  PageData,
  Access;
IMPORT
  AtomList;

CONST
  Brand			= "VirtualPage";

  
TYPE
  T			<: Public;

  Public		= <*TRANSIENT*> ROOT OBJECT
    METHODS
      putByte		(         pos   	:PageData.Index;
                                  value		:Type.Byte)
			RAISES {Access.Locked, FatalError};

      getByte		(         pos   	:PageData.Index)
			:Type.Byte
			RAISES {Access.Locked, FatalError};


      putShort		(         pos   	:PageData.Index;
                                  value		:Type.Short)
			RAISES {Access.Locked, FatalError};

      getShort		(         pos   	:PageData.Index)
			:Type.Short
			RAISES {Access.Locked, FatalError};


      putTriple		(         pos   	:PageData.Index;
                                  value		:CARDINAL (* Type.Triple *))
			RAISES {Access.Locked, FatalError};

      getTriple		(         pos   	:PageData.Index)
			: CARDINAL (* Type.Triple *)
			RAISES {Access.Locked, FatalError};


      putInt		(         pos   	:PageData.Index;
                                  value		:INTEGER)
			RAISES {Access.Locked, FatalError};

      getInt		(         pos   	:PageData.Index)
			:INTEGER
			RAISES {Access.Locked, FatalError};


      putWord		(         pos   	:PageData.Index;
                                  value		:Type.Word)
			RAISES {Access.Locked, FatalError};

      getWord		(         pos   	:PageData.Index)
			:Type.Word
			RAISES {Access.Locked, FatalError};


      putArray		(         pos   	:PageData.Index;
                         READONLY value		:PageData.Part)
			RAISES {Access.Locked, FatalError};

      getArray		(         pos   	:PageData.Index;
			 VAR      value		:PageData.Part)
			RAISES {Access.Locked, FatalError};

      copyArray		(         source 	:PageData.Index;
                                  destination	:PageData.Index;
                                  length	:PageData.Index)
			RAISES {Access.Locked, FatalError};


      putText		(         pos   	:PageData.Index;
                         READONLY value		:TEXT)
			RAISES {Access.Locked, FatalError};

      getText		(         pos   	:PageData.Index;
                                  length	:PageData.Index)
			:TEXT
			RAISES {Access.Locked, FatalError};


      putAll		(         unswizzler	:PageData.Unswizzler)
			RAISES {Access.Locked, FatalError};

      getAll		(	  swizzler	:PageData.Swizzler)
			RAISES {Access.Locked, FatalError};

      peekAll		(	  swizzler	:PageData.Swizzler)
			RAISES {FatalError};
    END;

EXCEPTION
  FatalError(AtomList.T);
  
END VirtualPage.
