INTERFACE ActiveAction;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:06 $
    $Log: ActiveAction.i3,v $
    Revision 1.2  1999/04/28 15:13:06  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:37  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:03:57  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The event handler
    subsystem implements the mapping between events and action via triggers.

*)
(***************************************************************************)

IMPORT Action, Event, ContextSet;

CONST Brand = "ActiveAction";

TYPE
  Struct = RECORD
             priority              : PriorityType;
             action                : Action.T;
             event                 : Event.T;
             context               : ContextSet.T;
             userdata              : <*TRANSIENT*> REFANY;
             level                 : CARDINAL;
             deleted               : BOOLEAN;
             nextClient, prevClient: T;
             nextLevel, prevLevel  : T;
           END;

  T = <*TRANSIENT*> REF Struct;

  PriorityType = RECORD prio, timeStamp: CARDINAL END;

PROCEDURE PrioLess (p1, p2: PriorityType): BOOLEAN;
PROCEDURE Priority (act: T): PriorityType;

END ActiveAction.
