(*!  DATA OBJECT MODULE *)
INTERFACE RemoteActivatedActions;

(***************************************************************************)
(** Created by:  Roland Baumann						   *)

(** $Author: hosking $
    $Revision: 1.2 $
    $Date: 1999/04/28 15:13:08 $
    $Log: RemoteActivatedActions.i3,v $
    Revision 1.2  1999/04/28 15:13:08  hosking
    Changes for PM3.

    Revision 1.1.1.1  1998/12/03 18:54:39  hosking
    Import of GRAS3-1.1

    Revision 1.1  1997/10/31 14:05:04  roland
    The RuleEngine subsystem implements an event-trigger mechanism for GRAS.
    It is splitted into local and remote rule handling. The remote rule handler
    connects to a special server object to communicate with other rule engines.

*)
(***************************************************************************)

IMPORT Event, Action, ContextSet;

PROCEDURE Store (event   : Event.T;
                 context : ContextSet.T;
                 priority: CARDINAL;
                 act     : Action.T;
                 userdata: <*TRANSIENT*> REFANY        );

PROCEDURE Get (VAR event   : Event.T;
               VAR context : ContextSet.T;
               VAR act     : Action.T;
               VAR userdata: <*TRANSIENT*> REFANY        ): BOOLEAN;

PROCEDURE Highest (): CARDINAL;
PROCEDURE NotEmpty (): BOOLEAN;

END RemoteActivatedActions.
