MODULE DBPage EXPORTS InternalDBPage, DBPage;

IMPORT Thread, ThreadF;
IMPORT RTDB;
IMPORT PStore; 
IMPORT BaseDBPage;
IMPORT InternalDatabase, BaseDatabase;
IMPORT Transaction, BaseTransaction, InternalTransaction;

REVEAL T = Internal BRANDED "DBPage.T" OBJECT
OVERRIDES
  init := Init;

  readAccess := ReadAccess;
  writeAccess := WriteAccess;
  peek  := Peek;
  read  := Read;
  write := Write;
END;


PROCEDURE Init(self: T): BaseDBPage.T =
  BEGIN
    EVAL BaseDBPage.T.init(self);
    RETURN self;
  END Init;


PROCEDURE ReadAccess(self: T) RAISES {Thread.Aborted} =
  VAR txn := NARROW(ThreadF.myTxn, Transaction.T);
  BEGIN
    PStore.lockPage(NARROW(txn, InternalTransaction.Internal).id,
                    NARROW(self.db, InternalDatabase.Internal).id,
                    self.id,
                    Transaction.LockMode.READ); 
  END ReadAccess;

PROCEDURE WriteAccess(self: T) RAISES {Thread.Aborted} =
  VAR txn := NARROW(ThreadF.myTxn, Transaction.T);
  BEGIN
    PStore.lockPage(NARROW(txn, InternalTransaction.Internal).id,
                    NARROW(self.db, InternalDatabase.Internal).id,
                    self.id,
                    Transaction.LockMode.WRITE);
    self.writer := txn;
  END WriteAccess;

PROCEDURE Read(self: T; p: RTDB.Swizzler) RAISES {Thread.Aborted} =
  VAR txn := NARROW(ThreadF.myTxn, Transaction.T);
  PROCEDURE P(READONLY data: RTDB.PageData) =
    BEGIN
      p(self, data);
    END P;
  BEGIN
    PStore.read(NARROW(txn, InternalTransaction.Internal).id,   <* NOWARN *>
                NARROW(self.db, InternalDatabase.Internal).id, 
                self.id,
                P); 
  END Read;

PROCEDURE Peek(self: T; p: RTDB.Swizzler) RAISES {Thread.Aborted} =
  VAR txn := NARROW(ThreadF.myTxn, Transaction.T);
  PROCEDURE P(READONLY data: RTDB.PageData) =
    BEGIN
      p(self, data);
    END P;
  BEGIN
    PStore.peek(NARROW(txn, InternalTransaction.Internal).id,   <* NOWARN *>
                NARROW(self.db, InternalDatabase.Internal).id,
                self.id,
                P); 
  END Peek;

PROCEDURE Write(self: T; p: RTDB.Unswizzler) RAISES {Thread.Aborted}  =
  VAR txn := NARROW(ThreadF.myTxn, Transaction.T);
  PROCEDURE P(VAR data: RTDB.PageData) =
    BEGIN
      p(self, data);
    END P;
  BEGIN
    <* ASSERT self.writer = txn *>
    PStore.write(NARROW(txn, InternalTransaction.Internal).id,   <* NOWARN *>
                 NARROW(self.db, InternalDatabase.Internal).id,
                 self.id, 
                 P);
    self.writer := txn;
  END Write;

BEGIN
END DBPage.








