INTERFACE PStore;

IMPORT Transaction;
IMPORT Database;
IMPORT RTDB;
IMPORT Thread;

EXCEPTION FatalError;

TYPE
  Swizzler            = PROCEDURE(READONLY data: RTDB.PageData);
  Unswizzler          = PROCEDURE(VAR data: RTDB.PageData);


PROCEDURE create(xct_id: RTDB.Id; database_name: TEXT): RTDB.Id
  RAISES { Database.Exists } ;
PROCEDURE open(xct_id: RTDB.Id; database_name: TEXT): RTDB.Id
  RAISES { Database.NotFound, Database.Opened} ;
PROCEDURE read(xct_id: RTDB.Id; 
               db_id: RTDB.Id;
               p_id: RTDB.Id; 
               swizzler: Swizzler)
  RAISES { Thread.Aborted };
PROCEDURE peek(xct_id: RTDB.Id; 
               db_id: RTDB.Id;
               p_id: RTDB.Id; 
               swizzler: Swizzler)
  RAISES { Thread.Aborted };
PROCEDURE write(xct_id: RTDB.Id; 
                db_id: RTDB.Id;
                p_id: RTDB.Id; 
                unswizzler: Unswizzler)
  RAISES { Thread.Aborted };
  
PROCEDURE lockPage(xct_id: RTDB.Id; 
                   db_id: RTDB.Id; 
                   p_id: RTDB.Id;
                   mode: Transaction.LockMode) 
  RAISES { Thread.Aborted };

PROCEDURE begin(): RTDB.Id RAISES
  { Transaction.InProgress } ;
PROCEDURE commit(xct_id: RTDB.Id) RAISES
  { Transaction.NotInProgress } ;
PROCEDURE chain(xct_id: RTDB.Id) RAISES
  { Transaction.NotInProgress } ;
PROCEDURE abort(xct_id: RTDB.Id) RAISES
  { Transaction.NotInProgress } ;


END PStore. 
