MODULE Page;

IMPORT RTDB, RTTxn, Shore, Transaction, ThreadF;
IMPORT RefTransientList AS ReaderList;

REVEAL T = RTDB.Page BRANDED "Page.T" OBJECT
  writer: RTTxn.T;
  readers: ReaderList.T;
OVERRIDES
  init := Init;
  readAccess := ReadAccess;
  writeAccess := WriteAccess;
  peekPin := PeekPin;
  readPin := ReadPin;
  writePin := WritePin;
  unpin := Unpin;
END;

PROCEDURE Init(self: T): RTDB.Page =
  BEGIN
    self.writer := ThreadF.myTxn;
    self.readers := NIL;
    RETURN self;
  END Init;

PROCEDURE ReadAccess(self: T; blocking: BOOLEAN): BOOLEAN =
  VAR txn := ThreadF.myTxn;
  BEGIN
    LOCK self DO
      IF ReaderList.Member(self.readers, txn) THEN RETURN TRUE; END;
      IF NOT blocking THEN RETURN FALSE; END;
      Shore.lockPage(ThreadF.MyTxn().id,       <* NOWARN *>
                     self.db.id,
                     self.id, 
                     Transaction.LockMode.READ); 
      self.readers := ReaderList.Cons(txn, self.readers);
      RETURN FALSE;
    END
  END ReadAccess;

PROCEDURE WriteAccess(self: T; blocking: BOOLEAN): BOOLEAN =
  VAR txn := ThreadF.myTxn;
  BEGIN
    LOCK self DO
      IF self.writer = txn THEN RETURN TRUE; END;
      IF NOT blocking THEN RETURN FALSE; END;
      Shore.lockPage(ThreadF.MyTxn().id,        <* NOWARN *>
                     self.db.id, 
                     self.id, 
                     Transaction.LockMode.WRITE);
      <* ASSERT self.readers.head = txn *>
      <* ASSERT self.readers.tail = NIL *>
      self.readers := NIL;
      self.writer := txn;
      RETURN FALSE;
    END
  END WriteAccess;

PROCEDURE PeekPin(self: T): ADDRESS =
  BEGIN
    RETURN Shore.pinPage(ThreadF.MyTxn().id,   <* NOWARN *>
                         self.db.id, 
                         self.id); 
  END PeekPin;

PROCEDURE ReadPin(self: T): ADDRESS =
  VAR txn := ThreadF.myTxn;
  BEGIN
    <* ASSERT ReaderList.Member(self.readers, txn) *>
    RETURN Shore.pinPage(ThreadF.MyTxn().id,   <* NOWARN *>
                         self.db.id, 
                         self.id); 
  END ReadPin;

PROCEDURE WritePin(self: T; READONLY data: RTDB.Bytes): ADDRESS =
  VAR txn := ThreadF.myTxn;
  BEGIN
    <* ASSERT self.writer = txn *>
    RETURN Shore.pinPage(ThreadF.MyTxn().id,   <* NOWARN *>
                         self.db.id, 
                         self.id, 
                         data);
  END WritePin;

PROCEDURE Unpin(self: T; modified: BOOLEAN) =
  VAR txn := ThreadF.myTxn;
  BEGIN
    <* ASSERT NOT modified OR self.writer = txn *>
    Shore.unpinPage(ThreadF.MyTxn().id,       <* NOWARN *>
                    self.db.id, 
                    self.id, 
                    modified);
  END Unpin;

BEGIN
END Page.
