INTERFACE Shore;

IMPORT Transaction;
IMPORT RTDB;


TYPE
  RequestType = {CREATE_R, OPEN_R, BEGIN_R, COMMIT_R, CHAIN_R, ABORT_R,
                 READ_PAGE_R, WRITE_PAGE_R, PEEK_PAGE_R, LOCK_PAGE_R};

  ResponseType = {OK, IN_PROG, N_IN_PROG, EXISTS, NOT_FOUND, OPENED, DEADLOCK};

PROCEDURE getResponseXct(): RTDB.Id;
PROCEDURE createReq(xct_id: RTDB.Id; database_name: TEXT);
PROCEDURE createResp(VAR db_id: RTDB.Id): ResponseType;
PROCEDURE openReq(xct_id: RTDB.Id; database_name: TEXT);
PROCEDURE openResp(VAR db_id: RTDB.Id): ResponseType;
PROCEDURE getPageReq(xct_id: RTDB.Id; 
                  db_id: RTDB.Id;
                  p_id: RTDB.Id; 
                  len: INTEGER;
                  type: RequestType);
PROCEDURE getPageResp(VAR buffer: RTDB.PageData): ResponseType; 
PROCEDURE putPageReq(xct_id: RTDB.Id; 
                       db_id: RTDB.Id;
                       p_id: RTDB.Id; 
                       VAR data: RTDB.PageData);
PROCEDURE putPageResp(): ResponseType;
PROCEDURE lockPageReq(xct_id: RTDB.Id; 
                      db_id: RTDB.Id;
                      p_id: RTDB.Id; 
                      mode: Transaction.LockMode);
PROCEDURE lockPageResp(): ResponseType;
PROCEDURE beginReq();
PROCEDURE beginResp(): ResponseType;
PROCEDURE commitReq(xct_id: RTDB.Id);
PROCEDURE commitResp(): ResponseType;
PROCEDURE chainReq(xct_id: RTDB.Id);
PROCEDURE chainResp(): ResponseType;
PROCEDURE abortReq(xct_id: RTDB.Id);
PROCEDURE abortResp(): ResponseType;

END Shore.



