/* C compiler: main program */

#include "version.h"
#include "c.h"

int Aflag;			/* >= 0 if -A specified */
int Pflag;			/* != 0 if -P specified */
int npoints;			/* # of execution points if -b specified */
int ncalled = -1;		/* #times prof.out says current function was called */
Symbol YYcounts;		/* symbol for _YYcounts if -b specified */
Symbol YYlink;			/* symbol for file's struct _bbdata */
Symbol YYnull;			/* symbol for _YYnull if -n specified */
Symbol YYprintf;		/* symbol for printf, if -t[name] specified */
int glevel;			/* == [0-9] if -g[0-9] specified */
int xref;			/* != 0 for cross-reference data */

int ZZverbose = 0;		/* verbosity level of exp server */
int ZZpsfd;			/* file descriptor to which postscript can be sent */
int NOARGB;			/* tells whether structs can be args */
int ZZgplimit;			/* number of bytes in a global area */

static char *infile;		/* input file */
static char *outfile;		/* output file */
static char *progname;		/* argv[0] */
static Symbol symroot;		/* root of the global symbols */

List loci, tables;		/* current (locus,table) lists */

dclproto(static void cmdloop,(int expfd))
dclproto(static int doargs,(int, char **))
dclproto(static void eval,(int expfd))
dclproto(static void setNOARGB,(int psfd))

int main(argc, argv) char *argv[]; {
	int expfd, symfd;

	assert(MAXKIDS >= 2);
	assert(MAXSYMS >= 2);
	progname = argv[0];
	errlimit = 0x7fffffff;
	typeInit();
	level = GLOBAL;
	if (argc == 2 && !strcmp(argv[1],"-readtypes")) {
		inputInit(0);
		t = gettok();
		while (t != EOI) {
			Type ty = gettype();
			fprint(1, "Read type #%d (%t)\n", ty->index);
			dumptypes(1);
			outflush();
		}
		return 0;
	}
	if (argc != 4)
		fatal("main", stringf("Usage: %s expfd symfd resfd\n", argv[0]), 0);
	expfd  = strtol(argv[1], (char **)0, 0);
	symfd  = strtol(argv[2], (char **)0, 0);
	ZZpsfd = strtol(argv[3], (char **)0, 0);

	inputInit(symfd); /* symfd will be primed with a newline */
	inputPush();
	inputInit(expfd);
	typeInitMetrics(ZZpsfd);
        setNOARGB(ZZpsfd);
	t = gettok();
	{
		Symbol p;
		enterscope(); enterscope();
		p = lookup("DebugNub_gp", identifiers);
		assert(isptr(p->type));
		ZZgplimit = p->type->type->size;
		if (ZZverbose)
			fprint(2, "Global space size is %d bytes.\n", ZZgplimit);
		exitscope(); exitscope();
	}
	cmdloop(expfd);
	outflush();
	exit(errcnt > 0);
	return 0;
}

static void setNOARGB(psfd) {
	fprint(psfd, "ExpressionServer.NOARGB\n");
	outflush();
	lexPush();
	inputSwap();
        t = gettok();
        assert(t == ICON);
        NOARGB = tsym->u.c.v.i;
	inputSwap();
	lexPop();
}

/* doargs - process program arguments, removing top-half arguments from argv */
static int doargs(argc, argv) char *argv[]; {
	char *s;
	int i, j, x;
	Symbol p;

	for (i = j = 1; i < argc; i++)
		if (strcmp(argv[i], "-A") == 0)
			Aflag++;
	        else if (strcmp(argv[i], "-") == 0 || *argv[i] != '-') {
			if (infile == 0)
				infile = argv[i];
			else if (outfile == 0)
				outfile = argv[i];
			else
				argv[j++] = argv[i];
		}
	argv[j] = 0;
	return j;
}

/* cmdloop - read on expfd
            ( : exp ; | + | - | typedef | ;)* EOI
 */
static void cmdloop(expfd) {
	Tree e;
	static Type voidproto[] = { 0, 0 };

	voidproto[0] = voidtype;
	cfunc = genident(AUTO, func(voidtype, voidproto), GLOBAL);
	do {
		int emitter = 2;
		errcnt = 0;
		switch (t) {
		    case ':' : /* eval */
			eval(expfd);
			break;
		    case '-' :
			t = gettok();
			fprint(2, "exp server ZZverbose == %d\n", --ZZverbose);    
			break;
		    case '+':
			t = gettok();
			fprint(2, "exp server ZZverbose == %d\n", ++ZZverbose);    
			break;
		    case '?':
			t = gettok();
			printtable(0, 0, 2);
			break;
		    case TYPEDEF:
			t = gettok();
			dumptypes(2);
			break;
		    case ';' :
			t = gettok();
			break;
		    case '.' :
			fprint(2, "Expression server asked to exit.\n");
			exit(0);
		    default:
			error("unrecognized request %k", t);
			while (t != ';' && t != EOI)
				t = gettok();
		}
	} while (t != EOI);
}

static void eval(expfd) {
	Tree e;
	Code cp;
	Symbol result;
	static Symbol locals[1] = {0};
	Type ty;

	/* code from funcdecl */
	labels[0] = table(0, LABELS);
	labels[1] = table(0, LABELS);
	refinc = 1000;
	bnumber = -1;
	codelist = &codehead;
	codelist->next = 0;
	fname = string("$exp");	/* causea asm() to be delayed appropriately */

	walk(0, 0, 0);
	cp = code(Blockbeg);
	enterscope();
	enterscope();		/* skip PARAM; go right to LOCAL */
	cp->u.block.bnumber = ++bnumber;
	cp->u.block.level = level;
	cp->u.block.locals = locals;

	t = gettok();		/* skip past initial : */
	e = value(expr(0));
	if (errcnt) {
	        if (ZZverbose)
			fprint(2, "====> Errors! (flushing) <====\n");
		fprint(ZZpsfd, "(?) null ExpressionServer.result\n");
		while (t != ';' && t != EOI)
			t = gettok(); 
		goto finish;
	}
	if (generic(e->op) == INDIR) { /* some help for enum designators */
		ty = e->kids[0]->type;
		assert(isptr(ty));
		ty = ty->type;
	} else if (isfunc(e->type))
		ty = ptr(e->type);
	else
		ty = e->type;
        if (unqual(e->type) == voidtype) {
		e = root(e);
        	result = voidtype->u.sym;
        } else {
		result = temporary(AUTO, ty);
		result->x.result = 1;
		if (isarray(ty))
			e = tree(ASGN+B, ty, idnode(result),
				 tree(INDIR+B, e->type, e, 0));
		else
			e = tree(ASGN+ttob(ty), ty, lvalue(idnode(result)), e);
	}
	if (ZZverbose)
		printtree(e, 2);
	walk(e, 0, 0);
	cp->u.block.identifiers = identifiers;
	cp->u.block.types = types;
	code(Blockend);

	if (errcnt) {
	        if (ZZverbose)
			fprint(2, "====> Errors! (flushing) <====\n");
		fprint(ZZpsfd, "(?) null ExpressionServer.result\n");
		while (t != ';' && t != EOI)
			t = gettok(); 
		goto finish;
	}
	{       static Symbol caller[1] = {0}, callee[1] = {0};
		flushequ();
		ZZsymcritical++; /* protect stream to debugger */
		function(cfunc, caller, callee, 0 /*cfunc->u.f.ncalls*/);

		/* If the type of the expression is known, I can send its index.
		   Otherwise, I can either make up a type dictionary or use the index of
		   a known type.  I make up type dictionaries for string constants and
		   function pointers. */
		if (result->type->index)
		  psprint("typecache %d get\n", result->type->index);
		else if (isarray(result->type) && ischar(unqual(result->type)->type))
		  psprint("<< /decl (char %%s[]) /size %d /printer {CHARARRAY} >>\n",
			  result->type->size);
		else if (isptr(result->type) && isfunc(unqual(result->type)->type))
		  psprint("<< /decl (unknown (*%%s)()) /printer {FUNSTAR} >>\n");
		else if (isptr(result->type))
		  psprint("typecache %d get %% unindexed pointer prints as void *\n",
			  voidptype->index);
		else {
		  error("result type not indexed!\n");
		  psprint("typecache %d get %% unindexed nonpointer prints as void\n",
			  voidtype->index);
		}
		psprint("ExpressionServer.result\n");
		ZZsymcritical--;
	}

    finish:
	outflush();
	expect(';');
	fname = 0;
	exitscope();
	exitscope();
	resettable(identifiers, GLOBAL); /* cf decl.c : finalize() */
	resettable(constants,   CONSTANTS);
	resettable(externals,   GLOBAL);    /* don't keep old external decls */
	tfree();
}

#ifdef __STDC__
void psprint(char *fmt, ...) {
#else
void psprint(fmt, va_alist) char *fmt; va_dcl {
#endif
	va_list ap;

	va_init(ap, fmt);
	if (ZZverbose)
		vfprint(2, fmt, ap);
	vfprint(ZZpsfd, fmt, ap);
	va_end(ap);
}
