<* LINE 2 "" *>
MODULE  StackOps EXPORTS InterpOps;
FROM InterpBasics IMPORT NewInteger, NewString, NewName, booleans, Register;<*NOWARN*>
FROM InterpTypes IMPORT
  Object, Access, Accessible, Integer, Real, Boolean, Array, <*NOWARN*>
  Name, String, Dictionary, Operator, Writer, Reader, Mark, Other, <*NOWARN*>
  Null, RefArray, Char;<*NOWARN*>
<* LINE 16 "" *>
IMPORT Interp;
<* LINE 18 "" *>
IMPORT InterpBasics;
<* LINE 20 "" *>
IMPORT InterpTypes;
<* LINE 22 "" *>
<* LINE 100 "generated-code" *>
PROCEDURE pop(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 1 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Object =>
      <* LINE 7 "Stack.ops" *>
<* LINE 200 "generated-code" *>
      DEC(interp.opsp, 1);
      RETURN; <*NOWARN*>
 ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END pop;
<* LINE 38 "" *>
<* LINE 400 "generated-code" *>
PROCEDURE exch(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 2 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Object (x2) =>
  TYPECASE interp.opstack[interp.opsp-2] OF Object (x1) =>
      <* LINE 7 "Stack.ops" *>
      interp.opstack[interp.opsp-2] := x2; interp.opstack[interp.opsp-1] := x1;
<* LINE 500 "generated-code" *>
      RETURN; <*NOWARN*>
 ELSE END; (* TYPECASE interp.opstack[interp.opsp-2] *)
 ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END exch;
<* LINE 56 "" *>
<* LINE 700 "generated-code" *>
PROCEDURE dup(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 1 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Object (x) =>
      IF interp.opsp + 1 > NUMBER(interp.opstack) THEN Interp.Overflow(interp, 1); END;
      <* LINE 8 "Stack.ops" *>
      interp.opstack[interp.opsp-0] := x;
<* LINE 800 "generated-code" *>
      INC(interp.opsp, 1);
      RETURN; <*NOWARN*>
 ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END dup;
<* LINE 74 "" *>
<* LINE 1000 "generated-code" *>
PROCEDURE copy(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 1 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Integer (n) => WITH n = n.i DO
      <* LINE 10 "Stack.ops" *>
        IF n > interp.opsp - 1 THEN Interp.Error(interp, "rangecheck");
        ELSIF interp.opsp+n-1 > NUMBER(interp.opstack) THEN Interp.Error(interp, "stackoverflow");
        ELSE
          FOR i := 0 TO n-1 DO
            interp.opstack[interp.opsp-1+i] := interp.opstack[interp.opsp-1-n+i];
          END;
          INC(interp.opsp,n);
        END;
<* LINE 1100 "generated-code" *>
      DEC(interp.opsp, 1);
      RETURN; <*NOWARN*>
  END; (* n.i *)  ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END copy;
<* LINE 98 "" *>
<* LINE 1300 "generated-code" *>
PROCEDURE index(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 1 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Integer (n) => WITH n = n.i DO
      <* LINE 19 "Stack.ops" *>
        IF n < 0 OR n > interp.opsp - 2 THEN Interp.Error(interp, "rangecheck");
        ELSE interp.opstack[interp.opsp-1] := interp.opstack[interp.opsp-2-n];
        END;
<* LINE 1400 "generated-code" *>
      RETURN; <*NOWARN*>
  END; (* n.i *)  ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END index;
<* LINE 116 "" *>
<* LINE 1600 "generated-code" *>
PROCEDURE roll(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
  IF interp.opsp < 2 THEN Interp.Error(interp, "stackunderflow"); END;
  TYPECASE interp.opstack[interp.opsp-1] OF Integer (j) => WITH j = j.i DO
  TYPECASE interp.opstack[interp.opsp-2] OF Integer (n) => WITH n = n.i DO
      <* LINE 23 "Stack.ops" *>
        IF n > interp.opsp - 2 THEN Interp.Error(interp, "rangecheck");
        ELSE
          WITH src = SUBARRAY(interp.opstack, interp.opsp-2-n, n),
               dst = NEW(RefArray,n)^ DO
            FOR i := 0 TO n-1 DO dst[(i+j) MOD n] := src[i] END;
            src := dst;
          END;
        END;
<* LINE 1700 "generated-code" *>
      DEC(interp.opsp, 2);
      RETURN; <*NOWARN*>
  END; (* n.i *)  ELSE END; (* TYPECASE interp.opstack[interp.opsp-2] *)
  END; (* j.i *)  ELSE END; (* TYPECASE interp.opstack[interp.opsp-1] *)
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END roll;
<* LINE 142 "" *>
<* LINE 1900 "generated-code" *>
PROCEDURE clear(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
      <* LINE 31 "Stack.ops" *>
      interp.opsp := 0;
<* LINE 2000 "generated-code" *>
      RETURN; <*NOWARN*>
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END clear;
<* LINE 155 "" *>
<* LINE 2200 "generated-code" *>
PROCEDURE count(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
      IF interp.opsp + 1 > NUMBER(interp.opstack) THEN Interp.Overflow(interp, 1); END;
      <* LINE 32 "Stack.ops" *>
      interp.opstack[interp.opsp-0] := NewInteger(interp.opsp);
<* LINE 2300 "generated-code" *>
      INC(interp.opsp, 1);
      RETURN; <*NOWARN*>
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END count;
<* LINE 170 "" *>
<* LINE 2500 "generated-code" *>
PROCEDURE mark(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
      IF interp.opsp + 1 > NUMBER(interp.opstack) THEN Interp.Overflow(interp, 1); END;
      <* LINE 33 "Stack.ops" *>
      interp.opstack[interp.opsp-0] := InterpBasics.mark;
<* LINE 2600 "generated-code" *>
      INC(interp.opsp, 1);
      RETURN; <*NOWARN*>
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END mark;
<* LINE 185 "" *>
<* LINE 2800 "generated-code" *>
PROCEDURE cleartomark(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
      <* LINE 35 "Stack.ops" *>
        VAR old := interp.opsp;
        BEGIN
          WHILE interp.opsp > 0 DO
            DEC(interp.opsp);
            IF ISTYPE(interp.opstack[interp.opsp],Mark) THEN
              RETURN;
            END;
          END;
          interp.opsp := old;
          Interp.Error(interp, "unmatchedmark");
        END;
<* LINE 2900 "generated-code" *>
      RETURN; <*NOWARN*>
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END cleartomark;
<* LINE 208 "" *>
<* LINE 3100 "generated-code" *>
PROCEDURE counttomark(interp:Interp.T) RAISES {InterpTypes.Exn} =
BEGIN
      IF interp.opsp + 1 > NUMBER(interp.opstack) THEN Interp.Overflow(interp, 1); END;
      <* LINE 47 "Stack.ops" *>
        VAR s := interp.opsp;
        BEGIN
          WHILE s > 0 AND NOT ISTYPE(interp.opstack[s-1], Mark) DO DEC(s) END;
          IF s > 0 THEN
            interp.opstack[interp.opsp-0] := NewInteger(interp.opsp - s);
          ELSE
            Interp.Error(interp, "unmatchedmark");
          END;
        END;
<* LINE 3200 "generated-code" *>
      INC(interp.opsp, 1);
      RETURN; <*NOWARN*>
  Interp.Error(interp, "typecheck"); <*NOWARN*>
END counttomark;
<* LINE 10 "" *>
BEGIN
 
<* LINE 3 "Stack.ops" *>
Register(mark, "[", "<<");
<* LINE 35 "" *>
<* LINE 300 "generated-code" *>
Register(pop,"pop");
<* LINE 53 "" *>
<* LINE 600 "generated-code" *>
Register(exch,"exch");
<* LINE 71 "" *>
<* LINE 900 "generated-code" *>
Register(dup,"dup");
<* LINE 95 "" *>
<* LINE 1200 "generated-code" *>
Register(copy,"copy");
<* LINE 113 "" *>
<* LINE 1500 "generated-code" *>
Register(index,"index");
<* LINE 139 "" *>
<* LINE 1800 "generated-code" *>
Register(roll,"roll");
<* LINE 152 "" *>
<* LINE 2100 "generated-code" *>
Register(clear,"clear");
<* LINE 167 "" *>
<* LINE 2400 "generated-code" *>
Register(count,"count");
<* LINE 182 "" *>
<* LINE 2700 "generated-code" *>
Register(mark,"mark");
<* LINE 205 "" *>
<* LINE 3000 "generated-code" *>
Register(cleartomark,"cleartomark");
<* LINE 228 "" *>
<* LINE 3300 "generated-code" *>
Register(counttomark,"counttomark");
<* LINE 12 "" *>
END  StackOps.
