INTERFACE SearchPath;

IMPORT OSError, Rd;

TYPE
  T = TEXT;  (* directories separated by colons *)
  FilePredicate = PROCEDURE (filename: TEXT): BOOLEAN;

PROCEDURE FileIsReadable (filename: TEXT): BOOLEAN;
(* Return TRUE iff filename names a readable file.         *)

PROCEDURE Lookup(path: T; filename: TEXT;
                 pred: FilePredicate := FileIsReadable): TEXT;
(* Most clients will not specify a filepred argument       *)
(* and will use this simply to find the first file         *)
(* that exists along a given search path.  More            *)
(* generally, SearchPath returns a pathname to the         *)
(* first instance of filename in the list of               *)
(* directories specified by the path for which the         *)
(* filepred returns TRUE.  If none exist, SearchPath       *)
(* returns NIL.                                            *)

PROCEDURE RdFromPath (path:T; filename: TEXT): Rd.T  RAISES {OSError.E};
(* This is a convenience routine and is a shorthand for    *)
(* FileRd.Open(Get(path, filename))                        *)

END SearchPath.
