(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Nov 19 09:27:05 PST 1994 by kalsow     *)
(*      modified on Tue May 11 16:49:30 PDT 1993 by mjordan    *)
(*      modified on Tue Apr 20 14:44:12 PDT 1993 by mcjones    *)
(*      modified on Sun Feb 21 14:59:10 PST 1993 by jdd        *)
(*      modified on Sat Jun 27 22:22:30 PDT 1992 by muller     *)

UNSAFE MODULE RTMisc;

IMPORT RTHeapRep, RTProcedure, RTProcedureSRC, RTProcess, RTIO;

(*------------------------------- rounded arithmetic ------------------------*)

PROCEDURE Align (a: ADDRESS; y: INTEGER): ADDRESS =
  BEGIN 
    RETURN LOOPHOLE (Upper (LOOPHOLE (a, INTEGER), y), ADDRESS);
  END Align;

PROCEDURE Upper (x, y: INTEGER): INTEGER =
  BEGIN
    RETURN ((x + y - 1) DIV y) * y;
  END Upper;

(*------------------------------- runtime error reporting -------------------*)

PROCEDURE FatalError (file            : TEXT;
                      line            : INTEGER;
                      msgA, msgB, msgC: TEXT      := NIL) =
  BEGIN
    StartError (msgA, msgB, msgC);
    IF (file # NIL) THEN
      RTIO.PutText ("\n***    file \"");
      RTIO.PutText (file);
      RTIO.PutText ("\", line ");
      RTIO.PutInt  (line);
    END;
    EndError ();
  END FatalError;

PROCEDURE FatalErrorS (file            : ADDRESS;
                       line            : INTEGER;
                       msgA, msgB, msgC: TEXT      := NIL) =
  BEGIN
    StartError (msgA, msgB, msgC);
    IF (file # NIL) THEN
      RTIO.PutText   ("\n***    file \"");
      RTIO.PutString (file);
      RTIO.PutText   ("\", line ");
      RTIO.PutInt    (line);
    END;
    EndError ();
  END FatalErrorS;

PROCEDURE FatalErrorI (msg: TEXT := NIL;  i: INTEGER) =
  BEGIN
    StartError (msg);
    RTIO.PutInt (i);
    EndError ();
  END FatalErrorI;

PROCEDURE FatalErrorPC (pc: INTEGER; msgA, msgB, msgC: TEXT := NIL) =
  VAR
    proc   : RTProcedure.Proc;
    file   : RTProcedureSRC.Name;
    name   : RTProcedureSRC.Name;
    offset : INTEGER;
  BEGIN
    StartError (msgA, msgB, msgC);
    IF RTHeapRep.Crash () THEN
      IF (pc # 0) THEN
        RTIO.PutText ("\n***    pc = ");
        RTIO.PutHex  (pc);
        VAR
          ignore1 : RTProcedureSRC.ProcInfo;
          ignore2 : RTProcedureSRC.UnitInfo;
          ignore3 : ADDRESS;
        BEGIN
          RTProcedureSRC.FromPC (LOOPHOLE(pc, ADDRESS), proc, ignore3,
                                 ignore1, ignore2, ignore2, file, name);
        END;
        offset := pc - LOOPHOLE (proc, INTEGER);
        IF (0 <= offset) AND (offset < 2048) THEN
          IF (name # NIL) THEN
            RTIO.PutText   (" = ");
            RTIO.PutString (name);
            IF (offset # 0) THEN
              RTIO.PutText (" + ");
              RTIO.PutHex  (offset);
            END;
          END;
          IF (file # NIL) THEN
            RTIO.PutText (" in ");
            RTIO.PutString (file);
          END;
        END;
      END;
    END;
    EndError ();
  END FatalErrorPC;

PROCEDURE StartError (msgA, msgB, msgC: TEXT := NIL) =
  BEGIN
    RTIO.PutText ("\n\n***\n*** runtime error:\n***    ");
    IF (msgA # NIL) THEN RTIO.PutText (msgA) END;
    IF (msgB # NIL) THEN RTIO.PutText (msgB) END;
    IF (msgC # NIL) THEN RTIO.PutText (msgC) END;
  END StartError;

PROCEDURE EndError () =
  BEGIN
    RTIO.PutText ("\n***\n\n");
    RTIO.Flush ();
    RTProcess.Crash (NIL);
  END EndError;

BEGIN
END RTMisc.
