(*
 * Copyright 1994-96 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *
 * HISTORY
 * 16-Apr-96  Yasushi Saito (yasushi) at the University of Washington
 *	Created.
 *)
MODULE ExtInfo;
IMPORT IWr, Module, RefSeq, Fmt, Type, Declaration;

CONST MaxArgs = 8;
  
PROCEDURE Output (READONLY m : Module.T) =
  VAR wr := IWr.OpenWrite(m.intf&"Info.i3");
    minProcID := LAST(INTEGER);
    maxProcID := FIRST(INTEGER);
    nProcs : CARDINAL;
    names := NEW(RefSeq.T).init();
    proc : Type.Proc;
    procDecl : Declaration.Proc;
  BEGIN
    wr.put(
	   "(* This file is produced by gen. Please do not edit this file directly.\n"
	   &"  Instead, kick yasushi@cs. *)\n");
    wr.put("INTERFACE "& m.intf & "Info;\n");
    
    FOR i := 0 TO m.names.size() -1 DO
      WITH genericDecl = m.names.get(i) DO 
	TYPECASE genericDecl OF
	| Declaration.Proc(decl) =>
	  maxProcID := MAX(decl.id, maxProcID);
	  minProcID := MIN(decl.id, minProcID);
	  wr.put("CONST ProcID_", decl.name, " = ", Fmt.Int(decl.id), ";\n");
	ELSE
	END;
      END;
    END;

    nProcs := maxProcID - minProcID + 1;
    wr.put("CONST ProcArgs = ARRAY [MinProcID .. MaxProcID] OF ARRAY [0..7] OF [0..8] {\n");
    wr.indent();
    
    FOR i := minProcID TO maxProcID DO
      IF Module.LookupProc(m, i, procDecl) THEN
	proc := procDecl.proc;
	names.addhi(procDecl.name);
      
	VAR args : ARRAY [0..MaxArgs-1] OF [0..8];
	BEGIN
	  FOR j := 0 TO LAST(args) DO
	    args[j] := 0;
	  END;
	  
	  FOR j := 0 TO LAST(proc.params^) DO
	    TYPECASE proc.params[j].type OF
	    | Type.Text =>
	      args[j] := 2;
	    ELSE
	      args[j] := 1;
	    END;
	  END;
	  wr.put("ARRAY [0..7] OF [0..8]{");
	  FOR j := 0 TO MaxArgs-1 DO
	    IF j > 0 THEN wr.put(", "); END;
	    wr.put(Fmt.Int(args[j]));
	  END;
	  wr.put("}");
	END;
      ELSE
	(* skipped *)
	names.addhi(NIL);
	wr.put("ARRAY [0..7] OF [0..8]{0, 0, 0, 0, 0, 0, 0, 0}");
      END;
      IF i < maxProcID THEN
	wr.put(",\n");
      ELSE
	wr.put("\n");
      END;
    END;
  
    wr.unindent();
    wr.put("};\n");
  
  
    wr.put("CONST MinProcID = ", Fmt.Int(minProcID), ";\n");
    wr.put("CONST MaxProcID = ", Fmt.Int(maxProcID), ";\n");
  
    wr.put("CONST ProcNames = ARRAY [MinProcID .. MaxProcID] OF TEXT {\n");
    wr.indent();

    (* Output proc name array *)
    FOR i := 0 TO names.size()-1 DO
      IF names.get(i) # NIL THEN 
	wr.put("\"", NARROW(names.get(i), TEXT), "\"");
      ELSE
	wr.put("NIL");
      END;
      IF i < names.size()-1 THEN
	wr.put(",\n");
      ELSE
	wr.put("\n");
      END;
    END;
    wr.unindent();
    wr.put("};\n");
  
    wr.put("END "&m.intf&"Info.\n");
    wr.close();
  END Output;

BEGIN
END ExtInfo.
