(*
 * Copyright 1994, 1995 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *)
(*
 * HISTORY
 * 17-Nov-95  Yasushi Saito (yasushi) at the University of Washington
 *	supported user defined types.
 *	
 *	
 *)
MODULE UserI3;
IMPORT Type, Module, Declaration, Msg;
IMPORT IWr;

PROCEDURE OutputType(name : TEXT; t : Type.T; wr : IWr.T) =
BEGIN
    
    wr.put("TYPE ", name, " = ", t.toText(FALSE, FALSE), ";\n");
END OutputType;

    
PROCEDURE OutputProc(intf : TEXT; name : TEXT; p : Type.Proc; wr : IWr.T) =
BEGIN
  IF p.needTrampolineCode THEN
    Msg.Fatal(p.srcPos, "Object method invocation is not supported now. \n");
  END;
  wr.put("<*EXTERNAL ", ExternalName(intf, name, p), " *>",
	 Type.OutputProcDecl(name, p, FALSE),
	 ";\n");
END OutputProc;


PROCEDURE Output(READONLY m : Module.T) =
  VAR wr := IWr.OpenWrite(m.intf&"User.i3");
  BEGIN
    wr.put(
   "(* This file is produced by gen. Please do not edit this file directly.\n"
   &"  Instead, kick yasushi@cs. *)\n");
    wr.put("UNSAFE INTERFACE "& m.intf & "User;\n");
    wr.put("IMPORT Word;\n");
    
    (* UNSAFE because the procs are implemented in assembler. *)

    FOR i := 0 TO m.names.size() -1 DO
      WITH genericDecl = m.names.get(i) DO 
	TYPECASE genericDecl OF
	| Declaration.Const(decl) =>
	  wr.put("CONST ", decl.name, "=", decl.value, ";\n");
	| Declaration.Proc(decl) =>
	  OutputProc(m.intf, decl.name, decl.proc, wr);
	| Declaration.Type(decl) =>
	  OutputType(decl.name, decl.type, wr);
	ELSE
	END;
      END;
    END;

    wr.put("END "&m.intf&"User.\n");
    wr.close();
  END Output;

PROCEDURE ExternalName(READONLY intf, proc : TEXT;
		       <*UNUSED*>p : Type.Proc) : TEXT =
BEGIN
  RETURN intf & "_" & proc;
END ExternalName;

BEGIN
END UserI3.
