(*
 * Copyright 1994-96 University of Washington
 * All rights reserved.
 * See COPYRIGHT file for a full description
 *
 * HISTORY
 * 17-Nov-96  Yasushi Saito (yasushi) at the University of Washington
 *	Created.
 *)

INTERFACE TransServiceRep;
IMPORT TransService;
IMPORT TransT;
IMPORT SID;
IMPORT WAL;

TYPE
  T = TransService.T;
  
REVEAL
  TransService.T = BRANDED OBJECT
    id: SID.T; (* persistent id for this storage.
		  XXX This id is supposed to be unique over the network.
		  However, there is currently no mechanism to ensure it!*)
    name: TEXT; (* only for debugging *)
  METHODS
    init(id: SID.T; name: TEXT): T;
    (* Initialize the data structure. "name" is uned only for debugging
       purpose. *)
    
    lock(); (* This is recursive lock, i.e., it can be locked
	       multiple times by same thread *)
    unlock();
    (* XXX lock and unlock are deprecated. Don't use any more. *)
    
    isLocked(): BOOLEAN;
    
    flushLog(lsn: INTEGER); (* write out all the log records up to LSN.
			       Pre: storage is locked.*)
  
    (* Below methods are used by the Transaction manager, not by
       the user *)
    
    prepare(tr: TransT.T; VAR lsn: WAL.LSN): BOOLEAN;
    (* Prepare for commit. Two phase commit stuff.
       "lsn" will hold the last LSN generated by the prepare operation.
       "lsn" should be set only when the service uses the
       "Transaction.DefaultLogDevice()". Otherwise, "lsn" should be set to
       MIN(WAL.LSN). *)
    
    commit(tr: TransT.T; VAR lsn: WAL.LSN);
    (* Commit. Used INTEGER two phase commit protocol. *)
    
    onePhaseCommit(tr: TransT.T; VAR lsn: WAL.LSN): BOOLEAN;
    (* Do prepare and commit at once. Used in one phase commit protocol. *)
    
    abort(tr: TransT.T);
  END;

END TransServiceRep.
