/* PULL2.PRB

	A particle of mass 4 kg rests on a smooth horizontal table.
	It is connected by a light inextensible string passing over a smooth
	pulley at the edge of the table to a particle of mass 2 kg, which
	is hanging freely.
	Find the acceleration of the system and the tension in the string.

				(from Bostock and Chandler 1975)
Alan Bundy 2.6.81 */

  problem(pulley,'Simple pulley problem.\n%r==\n\n',[=====,4]).

  isa(period,period0).
  isa(particle,particle4).
  isa(particle,particle2).
  mass(particle4,mass4,period0).
  mass(particle2,mass2,period0).
  accel(particle4,acceleration0,0,period0).
  tension(string0,tension0,period0).

  measure(mass4,4,kg).
  measure(mass2,2,kg).

  given(mass4).
  given(mass2).
  sought(acceleration0).
  sought(tension0).

  cue pullsys_stan(sys,pulley0,string0,particle4,particle2,period0).


