/* PULL3.PRB

	A particle of mass 5 kg rests on a rough horizontal table.
	It is connected by a light inextensible string passing over a smooth
	pulley at the edge of the table to a particle of mass of 6 kg, which
	is hanging freely.
	The coefficient of friction between the 5 kg mass and the table is 1/3.
	Find the acceleration of the system and the tension in the string.

				(from Bostock and Chandler 1975)
Alan Bundy 2.6.81 */

  problem(pulley,'Simple pulley problem.\n%r==\n\n',[=====,4]).

  isa(period,period0).
  isa(particle,particle5).
  isa(particle,particle6).
  mass(particle5,mass5,period0).
  mass(particle6,mass6,period0).
  accel(particle5,acceleration0,0,period0).
  tension(string0,tension0,period0).

  measure(mass5,5,kg).
  measure(mass6,6,kg).

  given(mass5).
  given(mass6).
  sought(acceleration0).
  sought(tension0).

  cue pullsys_stan(sys,pulley0,string0,particle5,particle6,period0).


