%   File   :  /usr/bs/lpdir/genprb.pl
%   Author : Bernard Silver
%   Updated: Tue Oct 15 12:01:32 1985
%   Purpose: Generate new problems to test schemas

generate(problem) :-
	reset,
	known_method_schema(_,_,_,_,schema(_,Eqn,_),_,_,_,_),
	!,
	g_p1(Eqn).

generate(problem) :-
	writef('\nNo schemas are stored, can''t generate problem.\n').

g_p1(Eqn) :-
	writef('\n
Attempting to generate a problem to test schema generated by problem\n%t\n',
[Eqn]),
	setof(N,problem(x,Eqn,N),Set),
	!,
	write_set(Set),
	length(Set,L),
	numbers_between(1,L,Num),
	process_reply([n|Num],get_problem(Eqn,x,Set,Ans),Ans,'Problem:',
writef('\nWhich problem do you want run? Type number or n for none.\n')).

g_p1(_) :-
	writef('\nUnable to generate a suitable problem.\n'),
	!.

problem(X,Eqn,New) :-
	known_method_schema(X,V,_,_,schema(_,Eqn,_),_,_,Precond,_),
	problem1(X,Eqn,New),
	V=New,
	check_cond(Precond).

problem1(X,Eqn=0,New) :-
	decomp(Eqn,[+|Args]),
	all_same_type(X,Args),
	sibling(Args,NewArgs),
	recomp(NewEqn,[+|NewArgs]),
	tidy(NewEqn=0,New).

problem1(X,A*B=0, New) :-
	decomp(A*B,[*|Args]),
	select(Term,Args,Rest),
	contains(X,Term),
	recomp(New2,[*|Rest]),
	problem1(X,Term=0,New1=0),
	tidy(New1*New2=0,New).

problem1(_,Eqn=A,Eqn=B) :-
	ok_number(A),
	A\==0,
	eval(A+1,B).

problem1(_,Eqn=A,Eqn=B) :-
	A=..[F|Args],
	get_new_args(Args,NewArgs),
	NewArgs\==Args,
	B=..[F|NewArgs].

problem1(X,Eqn=A,New=A) :-
	Eqn=..[F|Args],
	get_new_args1(X,Args,NewArgs),
	NewArgs \== Args,
	New=..[F|NewArgs].
	
get_new_args([],[]) :- !.
get_new_args([H|T],[H1|T1]) :- 
	eval(H+1,H1),
	get_new_args(T,T1).

get_new_args([H|T],[H|T1]) :- 
	get_new_args(T,T1).

get_new_args1(_,[],[]) :- !.
get_new_args1(X,[H|T],[H1|T1]) :-
	contains(X,H),
	return_new_term(H,H1),
	get_new_args1(X,T,T1).

get_new_args1(X,[H|T],[H|T1]) :-
	get_new_args1(X,T,T1).

return_new_term(A*B,New) :- !,
	decomp(A*B,[*|List]),
	select(El,List,Rest),
	ok_number(El),
	eval(El+1,El1),
	recomp(New,[*,El1|Rest]).

return_new_term(A,B) :- tidy(2*A,B).

all_same_type(X,[H|T]) :- 
	functor(H,F,N),
	all_same_type1(X,T,F,N).

all_same_type1(_,[],_,_) :- !.
all_same_type1(X,[H|T],F,N) :-
	functor(H,F,N),
	all_same_type1(X,T,F,N).

all_same_type1(X,[H*I|T],F,N) :-
	decomp(H*I,List),
	check_functor(X,List),
	all_same_type1(X,T,F,N).


check_functor(_,[]).
check_functor(X,[H|T]) :-
	freeof(X,H),
	!,
	check_functor(X,T).
check_functor(X,[_|T]) :-
	!,
	check_free(X,T).

check_free(_,[]).
check_free(X,[H|T]) :-
	freeof(X,H),
	!,
	check_free(X,T).


sibling(List,[NewTerm|Rest]) :-
	select(Term,List,Rest),
	sibling_term(Term,NewTerm).

sibling_term(H,H1) :-
	tree(_,Tree),
	member(type(Type,H,F1),Tree),
	member(type(Type,_,F2),Tree),
	F1 \== F2,
	H=..[F1|Args],
	H1 =.. [F2|Args].

sibling_term(A*B,New) :- return_new_term(A*B,New).

sibling_term(Term,New) :-
	Term =.. [F|Args],
	sibling(Args,NewArgs),
	New =.. [F|NewArgs].

write_set(Set) :-
	writef('\nThe set of generated problems is:\n'),
	write_set1(Set,1).

write_set1([],_) :- writef('\n[End of set]\n').
write_set1([H|T],N) :- 
	writef('\n%t)\t\t%t\n',[N,H]),
	M is N + 1,
	!,
	write_set1(T,M).

numbers_between(L,M,[]) :- L> M,!.
numbers_between(N,M,[N|T]) :-
	M1 is N + 1,
	!,
	numbers_between(M1,M,T).

get_problem(_,_,_,n) :- !,
	writef('\nOK, no test problems will be run.\n').

get_problem(Eqn,X,Set,N) :-
	nmember(New,Set,N),
	writef('\nEquation\n\n%t\n\nselected.\n\nRun begins:\n',[New]),
	initialize_screen,
	loop_flag(warn1),
	get_problem1(X,Eqn,New),
	!.

get_problem1(X,Eqn,New) :-
	known_method_schema(X,New,_,_,schema(Schema,Eqn,_),Type,_,_,_),
	sort_solve1(New,X,Ans,Schema,Type,_,0,_,100),
	!,
	writef('\nSchema solves test problem.\n').

get_problem1(X,_,New) :-
	writef('\n[**Unable to solve test problem with schema**]\n'),
	writef('\nTrying to solve without schema.\n'),
	!,
	get_problem2(X,New).


get_problem2(X,Eqn) :-
	reset,
	sort_solve(Eqn,X,_,_,_-[],0,_,100),
	!,
	writef('\n
[**Test problem can be solved without schema, may need concept learning**]\n').


get_problem2(_,_) :- writef('\n[Test problem could not be solved by LP]\n').

 % Args of tree are name and structure.
 % Structure is a list of type(Class,Term,Termname) predicates.

tree(trig_tree,
	[type(sincos,sin(_),sin),
	type(sincos,cos(_),cos),
	type(other,tan(_),tan),
	type(other,sec(_),sec),
	type(other,cosec(_),cosec),
	type(other,cot(_),cot)]).
	

tree(log_tree,[type(log,log(_,_),log)]).

