/* 
	if.m -- prolog microcode interface

	Copyright (c) 1986 by High Level Hardware Limited
*/

*I proregs.m
*I proops.m
*I proconsts.m
*I opcodes.m
*I prvreg.m
*I trapcodes.m

GLOBAL	cexit, mexit, cfexit, cpnoop, cbackup, copyFetch, matchFetch
GLOBAL	copyFetch1, copyFetch2, matchFetch1, matchFetch2
GLOBAL	mfexit, mpnoop, mbackup, pctobyte, pctoword, fillIr0

EXTERNAL rcache, noop, restart, trap, wcache, rwcache

ENTRY	umode + mstartProlog

	LDCT	fixup  DZ D=CSH  OR  RAMF B=R1  DECCA		// upper
	CONT	DZ D=BR, prcache  OR  HLDCA
	CJS	savecregs  DZ D=CSH  OR  RAMF B=R0	// lower
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CJS	getpregs  AB A=R0  SUBR CIN  RAMF B=R1
	CONT	DA D=BR, 2 A=R1  ADD  RAMD B=R1
	CONT	DZ D=BR, pswapbase+r0  OR  ALDCA
	CJS	loadpregs
	CONT	INCCA
	CJP	NZ, restart  ZQ  ADD CIN
	CONT	DZ D=BR, prinst  OR  HLDIR		/* Prolog inst set */
	CJS	fillIr0  AB A=R0 B=R0  SUBR  QREG
	LDCT	mfexit

// Fall through to fetch first instruction

ENTRY	matchmode + 0
matchFetch:		// matchmode in alternate instruction set
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
matchFetch1:
	CJV	NZ  DA D=BR,3 A=pc  AND
matchFetch2:
	CONT	ZB  ADD CIN  RAMA A=sp B=pc  ALDCA

	CONT	ZA A=pc  OR  RAMD B=ir0
	CONT	ZB  OR  RAMD B=ir0
	CONT	ZA A=ir0  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  AB A=R0 B=R0 SUBR  QREG  LOCK
	LDCT	mfexit  ZB  SUBR  RAMF B=pc  RD
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	DZ D=BUS  OR  RAMF B=ir0  ALDIR
	CJV	NINT  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CJP	NLC, intexit
	CONT	DZ D=BR, mstartProlog  OR  LDIR
//----------

ENTRY	umode + cstartProlog

	LDCT	fixup  DZ D=CSH  OR  RAMF B=R1  DECCA		// upper
	CONT	DZ D=BR, prcache  OR  HLDCA
	CJS	savecregs  DZ D=CSH  OR  RAMF B=R0	// lower
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CJS	getpregs  AB A=R0  SUBR CIN  RAMF B=R1
	CONT	DA D=BR, 2 A=R1  ADD  RAMD B=R1
	CONT	DZ D=BR, pswapbase+r0  OR  ALDCA
	CJS	loadpregs
	CONT	INCCA
	CJP	NZ, restart  ZQ  ADD CIN
	CONT	DZ D=BR, prinst  OR  HLDIR		/* Prolog inst set */
	CJS	fillIr0  AB A=R0 B=R0  SUBR  QREG
	LDCT	cfexit

// Fall through to fetch first instruction

ENTRY	copymode + 0
ENTRY	copymode + untr0
copyFetch:
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
copyFetch1:
	CJV	NZ  DA D=BR,3 A=pc  AND
copyFetch2:
	CONT	ZB  ADD CIN  RAMA A=sp B=pc  ALDCA

	CONT	ZA A=pc  OR  RAMD B=ir0
	CONT	ZB  OR  RAMD B=ir0
	CONT	ZA A=ir0  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  AB A=R0 B=R0 SUBR  QREG  LOCK
	LDCT	cfexit  ZB  SUBR  RAMF B=pc  RD
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	DZ D=BUS  OR  RAMF B=ir0  LDIR
	CJV	NINT  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CJP	NLC, intexit
	CONT	DZ D=BR, cstartProlog  OR  LDIR
//----------

fixup:
	JUMP	noop  ZB  AND  HLDCA
	CONT	ZB  AND  HLDIR
//----------

mexit:
cexit:
	CJS	savepregs
	CONT	DZ D=BR, pswapbase+pad  OR  ALDCA
	CONT	DZ D=BR, regarea+14  OR  ALDCA
	CONT	ZB  AND  HLDCA			// C stack
	LDCT	putpregs  DZ D=CSH  SUB  LDCA
	JSRP	F  DZ D=BR, prcache  OR  HLDCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CJS	loadcregs  ZA  AND  HLDIR
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CONT	DZ SHR1  OR  RAMA A=ir0 B=ir0  LDIR
	CONT	ZB  AND  HLDCA
	CJV	ZB  SUBR  RAMF B=sp  LDCA
	CONT	ZQ  OR  CWR
//----------

mbackup:
	CONT	ZB  SUBR  RAMF B=pc
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
mpnoop:
	CONT	ZB  SUBR  RAMF B=pc
	CONT	AB A=R0 B=R0  SUBR  QREG
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
mfexit:
	JUMP	fexit
	CONT	DZ D=BR, mstartProlog  OR  LDIR
//----------

cbackup:
	CONT	ZB  SUBR  RAMF B=pc
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
cpnoop:
	CONT	ZB  SUBR  RAMF B=pc
	CONT	AB A=R0 B=R0  SUBR  QREG
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
cfexit:
	CONT	DZ BR, cstartProlog  OR  LDIR
fexit:
	CJS	savepregs
	CONT	DZ D=BR, pswapbase+pad  OR  ALDCA
	CONT	DZ D=BR, regarea+14  OR  ALDCA
	CONT	ZB  AND  HLDCA		// C stack
	LDCT	putpregs  DZ D=CSH  SUB  LDCA
	JSRP	F  DZ D=BR, prcache  OR  HLDCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CONT	ZA A=sp  OR  RAMF B=R0
	CJS	loadcregs  ZA  AND  HLDIR
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CONT	ZB  AND  HLDCA
	JUMP	noop  ZA A=sp  OR  LDCA
	CONT	ZA A=R0  OR  CWR
//----------

intexit:
	CONT	ZB  SUBR  RAMF B=pc
	CONT	AB A=R0 B=R0  SUBR  QREG
	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
	CJS	savepregs
	CONT	DZ D=BR, pswapbase+pad  OR  ALDCA
	CONT	DZ D=BR, regarea+14  OR  ALDCA
	CONT	ZB  AND  HLDCA		// C stack
	LDCT	putpregs  DZ D=CSH  SUB  LDCA
	JSRP	F  DZ D=BR, prcache  OR  HLDCA
	CONT	DZ D=CSH  OR  RAMF B=R0
	CONT	ZA A=sp  OR  RAMF B=R0
	CJS	loadcregs  ZA  AND  HLDIR
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CONT	ZA A=sp  OR LDCA
	CONT	ZB  AND  HLDCA
	CONT	ZA A=R0  OR  CWR
	LDCT	trap  DZ  SHL1  OR  RAMA A=ir0 B=ir0
	JRP	F  DA D=CAIR MASK A=ir0  OR  RAMF B=ir0
	CONT	DZ D=BR, interrupt+256  OR  QREG
//----------

savecregs:
// save registers to the addressed cache location

	CONT	ZA A=R5  OR  CWR  INCCA
	CONT	ZA A=R6  OR  CWR  INCCA
	CONT	ZA A=R7  OR  CWR  INCCA
	CONT	ZA A=R8  OR  CWR  INCCA
	CONT	ZA A=R9  OR  CWR  INCCA
	CONT	ZA A=R10  OR  CWR  INCCA
	CONT	ZA A=R11  OR  CWR  INCCA
	CONT	ZA A=R12  OR  CWR  INCCA
	CONT	ZA A=R13  OR  CWR  INCCA
	CRTN	ZA A=R14  OR  CWR  INCCA
	CONT	ZA A=R15  OR  CWR
//----------

loadcregs:
// load registers from the addressed cache location

	CONT	INCCA
	CONT	DZ D=CSH  OR  RAMF B=R5  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R6  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R7  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R8  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R9  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R10  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R11  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R12  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R13  INCCA
	CRTN	DZ D=CSH  OR  RAMF B=R14
	CONT	DZ D=CSH  OR  RAMF B=R15
//----------

loadpregs:
// load registers from addressed location
	CONT	DZ D=CSH  OR  RAMF B=R0  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R1  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R2  INCCA
	CONT	DZ D=CSH  OR  RAMF B=R3  INCCA
	CONT	DZ D=CSH  OR  RAMF B=ip  INCCA
	CONT	DZ D=CSH  OR  RAMF B=ir0  INCCA
	CONT	DZ D=CSH  OR  RAMF B=d  INCCA
	CONT	DZ D=CSH  OR  RAMF B=cl  INCCA
	CONT	DZ D=CSH  OR  RAMF B=l  INCCA
	CONT	DZ D=CSH  OR  RAMF B=xc  INCCA
	CONT	DZ D=CSH  OR  RAMF B=m0  INCCA
	CONT	DZ D=CSH  OR  RAMF B=tr  INCCA
	CONT	DZ D=CSH  OR  RAMF B=g  INCCA
	CONT	DZ D=CSH  OR  RAMF B=bl  INCCA
	CONT	DZ D=CSH  OR  RAMF B=sp  INCCA
	CONT	DZ D=CSH  OR  RAMF B=pc
	CONT	DZ D=CSH  OR  QREG

	CONT	DZ D=BR, pswapbase+pad  OR  ALDCA
	CONT	DA D=BR, pswapbase+padarray A=sp  ADD  RAMF B=sp
	CONT	DA D=CSH A=sp  SUBR CIN  RAMF B=sp
pctobyte:
// convert to byte pc
	CJS	OS, @1  ZB  OR  RAMU B=pc
	CRTN	LC
	CRTN	ES  ZB  OR  RAMU B=pc
	CRTN	NLC  DA D=BR, (3<<4) SHL3 A=pc  NOTRS  RAMF B=pc
@1:
	CONT	ZB  ADD CIN  RAMF B=pc
//----------

pctoword:
// convert from byte pc
	CJS	OD, @1  ZB  OR  RAMD B=pc
	CRTN	LC
	CRTN	EV  ZB  OR  RAMD B=pc
	CRTN	NLC
@1:
	CONT	DA D=BR, (2<<2) SHL3 A=pc  OR  RAMF B=pc

savepregs:
	CONT	DA D=BR, pswapbase+padarray A=sp  SUBR CIN  RAMF B=sp
	CJS	pctoword  DA D=CSH A=sp  ADD  RAMF B=sp
	CONT	DZ D=BR, pswapbase+r0  OR  ALDCA

// save Prolog registers to addressed location
	CONT	ZA A=R0  OR  CWR  INCCA
	CONT	ZA A=R1  OR  CWR  INCCA
	CONT	ZA A=R2  OR  CWR  INCCA
	CONT	ZA A=R3  OR  CWR  INCCA
	CONT	ZA A=ip  OR  CWR  INCCA
	CONT	ZA A=ir0  OR  CWR  INCCA
	CONT	ZA A=d  OR  CWR  INCCA
	CONT	ZA A=cl  OR  CWR  INCCA
	CONT	ZA A=l  OR  CWR  INCCA
	CONT	ZA A=xc  OR  CWR  INCCA
	CONT	ZA A=m0  OR  CWR  INCCA
	CONT	ZA A=tr  OR  CWR  INCCA
	CONT	ZA A=g  OR  CWR  INCCA
	CONT	ZA A=bl  OR  CWR  INCCA
	CONT	ZA A=sp  OR  CWR  INCCA
	CONT	ZA A=pc  OR  CWR  INCCA
	CONT	ZQ  OR  RAMF  B=R0  CWR  INCCA
	CONT	DZ ZZZC  OR  RAMA A=R0 B=R0
	CRTN	ZA A=R0  OR  QREG
	CONT	D=VAR  CWR
//----------

fillIr0:
	CONT	ZA A=pc  OR  RAMD B=ir0
	CONT	ZB  OR  RAMD B=ir0
	CONT	ZA A=ir0  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	CRTN	Z  DA D=BR, 3  A=pc  AND  RAMF B=R1
	CONT	DZ D=BUS  OR  RAMF B=ir0

	CRTN	Z  ZB  SUBR  RAMF B=R1
	CONT	DZ  RTR1  OR  RAMA A=ir0 B=ir0		
	CRTN	Z  ZB  SUBR  RAMF B=R1
	CRTN	NLC  DZ  RTR1  OR  RAMA A=ir0 B=ir0		
	CONT	DZ  RTR1  OR  RAMA A=ir0 B=ir0		
//----------

getpregs:

// First check the stack is valid
	CONT	DA D=BR, pframesize + padsize A=R0  ADD  LVAR
	CONT	DZ D=BR, pswapbase  OR  ALDCA
	CJS	WFLT, rwcache
	CONT

@loop:
	CONT	ZA A=R0  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, rwcache  LOCK
	CONT	RD
	CONT	DA D=BR, 2 A=R0  ADD  RAMF B=R0  RRD
	CJP	NZ, @loop  ZB  SUBR  RAMF B=R1  D=BUS  CWR  INCCA
	CRTN	NLC  D=BUS  CWR  INCCA
	CONT
//----------

putpregs:
	CONT	DA D=BR, pconstsize A=R0  ADD  RAMF B=R0
	CONT	DA D=BR, 2 A=R0  SUBR CIN  RAMF B=R1
	CONT	AB A=sp  SUB CIN  RAMD B=R1
	CONT	DZ D=BR, pswapbase+varbase  OR  ALDCA
@loop:
	CONT	ZA A=R0  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK  INCCA
	LDCT	bodge  D=CSH  LBR  WR
	CJP	NZ, @loop  ZB  SUBR  RAMF B=R1  D=CSH  LBR  RWR  INCCA
	CONT	DA D=BR, 2 A=R0  ADD  RAMF B=R0
// restore the VAR
	CONT	DZ D=BR, pswapbase+var  OR  ALDCA
	CRTN
	CONT	DZ D=CSH  OR  LVAR
//----------

bodge:
	CJS	loadcregs  ZA  AND  HLDIR
	CONT	DZ D=BR, regarea+5  OR  ALDCA
	CONT	ZA A=sp  OR LDCA
	CONT	ZB  AND  HLDCA
	LDCT	trap  DZ  SHL1  OR  RAMA A=ir0 B=ir0
	JRP	F  DA D=CAIR MASK A=ir0  OR  RAMF B=ir0
	CONT	DZ D=BR, 42  OR  QREG
