/*
	proconsts.m -- prolog microcode constants

	Copyright (c) 1986 by High Level Hardware Limited
*/

/* tag fields &  masks */

tagmask		= (0fh << 4)

inttag		= 0
floattag	= (1 << 4)
atomtag		= (2 << 4)
boxtag		= (3 << 4)
termtag		= (4 << 4)
constag		= (5 << 4)
linktag		= (6 << 4)
undeftag	= (7 << 4)
functortag	= (8 << 4)
blocktag	= (9 << 4)
emptytag	= (10<< 4)
termintag	= (11<< 4)
proctag		= (12<< 4)
tabletag	= (13<< 4)
tabreftag	= (14<< 4)
clausetag	= (15<< 4)

/* Stack offsets */

a1off		= 8
bpoff		= 1
bloff		= 2
troff		= 3
cpoff		= 4
cloff		= 5
xcoff		= 6
goff		= 7
actsize		= 8

funatoff	= 0
funaroff	= 1
profunoff	= 3
proclaoff	= 5

fixfiroff	= 1

clauselen	= 7
claflaoff	= 0
clakeyoff	= 1
clatexoff	= 3
claforoff	= 6
cfsize		= 0ffh
cfclaimed	= 0100h
cfdoomed	= 0200h
cfrefmask	= 0ffh		// SHL2

pswapbase	= 64	  	// offset to ALDCA unused by C
pframesize	= 32		// Size of structure passed from C
padsize		= 100		// Size of pad[]
pconstsize	= 8		// Number of constants
zipsign		= 8		// sign bit for zip words (shl3)
extend		= 0f0h		// sign extend to 32 bits

// QREG return code

munimpl		= 100H		// unimplemented matchmode instruction
cunimpl		= 200H		// unimplemented copymode instruction
trapBit		= 300H		// processor trap occurred
fatalBit	= 400H		// fatality occurred

// Call codes

deallocCode	= 5		// call dealloc
primhandleCode	= 6		// call primhandle
findfunctCode	= 7		// call findfunct
findprocCode	= 8		// call findproc

// Offsets in syswords

swunder		=	0
swstart		=	1
swrootmod	=	2
swuser		=	3
swdot		=	4
swfundot	=	5
swdatabase	=	6
swsource	=	7
swminus		=	8
swnoculp	=	9
swreslim	=	10
swunknown	=	11
swisproc	=	12
swbreak		=	13
sweof		=	14
swnil		=	15
swcut		=	16
swsemicol	=	17
swbraces	=	18
swfunbraces	=	19
swfuncall	=	20
swfuncomma	=	21
swfunsemicolon	=	22
swfunarrow	=	23

