/*
	xpmatch.m -- prolog machine matchmode instructions

	Copyright (c) 1987 by High Level Hardware Limited
*/

*I	proregs.m
*I	proops.m
*I	proconsts.m

EXTERNAL rcache, wcache, matchFetch, copyFetch, Fail, Lab1
EXTERNAL copyFetch1, copyFetch2, matchFetch1, matchFetch2
EXTERNAL mbackup, mpnoop, dref, mexit, in_trail, fault, checkGlobal
EXTERNAL mfexit, unify
GLOBAL	rst084, rst085, rst086, rst087
GLOBAL	rst090, rst093, rst094, rst095
GLOBAL	rst096, rst097

DEFAULTENTRY	matchmode

	CONT	DZ RTL1  OR  RAMA A=ir0 B=ir0
	JUMP	mexit  ZB  SUBR  RAMF B=pc
	CONT	DZ D=BR, munimpl  OR  QREG
//----------

ENTRY	matchmode + ivar

	/*
		R0 = *D++;
		R1 = *(CL + *PC++);
		if (unify ()) goto MatchMode; else goto Fail;
	*/
	
	CONT	ZA A=d  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CONT	DZ MASK  OR  RAMA A=ir0 B=R1
	CONT	AB A=cl B=R1  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R0  LOCK
	LDCT	mbackup  DZ RTR1  OR  RAMA A=ir0 B=ir0  RD
	CONT	ZB  ADD CIN  RAMF B=d
	JUMP	unify  ZB  AND  RAMU ONE B=R2
	CONT	DZ D=BUS  OR  RAMF B=R1
//----------

ENTRY	matchmode + firstvar

	/*
		R0 = *D++;
		deref (R0);
		*(CL + *PC++) =
			(tag (R0) == UNDEF) ? makeword (LINK, val (R0)) : R0;
		goto MatchMode;
	*/

	CONT	DZ D=BR, undeftag SHL3  OR  RAMA A=d B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJP	NZ, firvar1  AQ A=R2  EXOR

	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R1
	CONT	DA D=BR, linktag SHL3 A=R1  OR  RAMF B=R0
firvar1:
	CONT	DZ MASK  OR  RAMA A=ir0 B=R1
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	AB A=cl B=R1  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=d  D=TB  LBR  ADDR
	CJP	NWFLT, matchFetch  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
	LDCT	mbackup  ZB  SUBR  RAMF B=d
	JUMP	matchFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
//----------

ENTRY	matchmode + void

	/*
		D++;
		goto MatchMode;
	*/

	JUMP	matchFetch1  ZB  ADD CIN  RAMF B=d
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
//----------

ENTRY	matchmode + voidn

	/*
		D += *PC++;
		goto MatchMode;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	AB A=R0  ADD  RAMF B=d
	JUMP	matchFetch  DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
//----------

ENTRY	matchmode + ifunctor

	/*
		R0 = *D++;
		deref(R0);
		if (tag (R0) == UNDEF)
		{
			in_trail (R0);
			memoff0(R0) = makeword (TERM, (int) G);
			*G++ = *(XC + CLAUSELEN + *PC++);
			*++SP = (int) D;
			*++SP = 1;
			D = G;
			G += *PC++;
			checkglobal (12);
			goto CopyMode;
		}
		if (tag (R0) != TERM) goto Fail;
		if (termfunctor (R0) != *(XC + CLAUSELEN + *PC++) goto Fail;
		PC++;
		*++SP = (int) D;
		*++SP = 1;
		D = (int *) val (R0) + 1;
		goto MatchMode;
	*/

	CONT	DZ D=BR, undeftag SHL3  OR  RAMA A=d B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DZ MASK  OR  RAMA A=ir0 B=R3
	CONT	DA D=BR, clauselen A=R3  ADD  RAMF B=R3
	CONT	AB A=xc B=R3  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	mbackup  RD
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJP	NZ, ifunc1  AQ A=R2  EXOR
	CJS	NLC, in_trail  DZ D=BUS  OR  RAMF B=R3
	LDCT	mbackup
rst086:
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  LVAR
	CONT	DA D=BR, termtag SHL3  A=g  OR  RAMF B=R1
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix086  ZA A=R1  OR  LBR  WR
rst087:
	CONT	ZB  ADD CIN  RAMA A=g B=g  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix087  ZA A=R3  OR  LBR  WR
	CONT	ZB  ADD CIN  RAMF B=sp  ALDCA
	CONT	ZB  ADD CIN  RAMF B=sp
	CONT	ZA A=d  ADD CIN  CWR  INCCA
	CONT	ZA A=g  OR  RAMF B=d  D=BR,1  CWR
	CONT	DZ  MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CJS	checkGlobal  AB A=R0  ADD  RAMF B=g
	CONT	DZ D=BR, 10  OR  RAMF B=R0
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=pc
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
ifunc1:
	CONT	NZ  DQ D=BR, termtag SHL3  EXOR
	CJP	LC, Fail  ZB  ADD CIN  RAMF B=d
rst090:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix090  RD
	CONT
	CJP	NZ, Fail  DA D=BUS A=R3  EXOR
	CONT	ZA A=sp  ADD CIN  ALDCA
	CONT	ZB  ADD CIN  RAMA A=d B=sp  CWR  INCCA
	CONT	ZB  ADD CIN  RAMF B=sp
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=d
	CONT	ZB  ADD CIN  RAMF B=d  D=BR, 1  CWR
	CJP	matchFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

fix086:
	JUMP	mfexit
	CONT	DZ D=BR, 86  OR  QREG
	
fix087:
	JUMP	mfexit  ZB  SUBR  RAMF B=g
	CONT	DZ D=BR, 87  OR  QREG
	
fix090:
	JUMP	mfexit
	CONT	DZ D=BR, 90  OR  QREG
//----------

ENTRY	matchmode + conslist

	/*
		R0 = *D++;
		deref(R0);
		if (tag (R0) == UNDEF)
		{
			checkglobal (12);
			in_trail (R0);
			memoff0(R0) = makeword (CONS, (int) G);
			*++SP = (int) D;
			*++SP = 1;
			D = G;
			G += 2;
			goto CopyMode;
		}
		if (tag (R0) != CONS) goto Fail;
		*++SP = (int) D;
		*++SP = 1;
		D = (int *) val (R0);
		goto MatchMode;
	*/

	CONT	DZ D=BR, undeftag SHL3  OR  RAMA A=d B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJP	NZ, consl1  AQ A=R2  EXOR
	CJS	NLC, checkGlobal  ZA A=R0  OR  RAMF B=R2
	CONT	DZ D=BR, 12  OR  RAMF B=R0
	CJS	in_trail
	LDCT	mpnoop  ZA A=R2  OR  RAMF B=R0
rst084:
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  LVAR
	CONT	DA D=BR, constag SHL3  A=g  OR  RAMF B=R1
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix084  ZA A=R1  OR  LBR  WR

	CONT	ZB  ADD CIN  RAMF B=sp  ALDCA
	CONT	ZA A=d  ADD CIN  CWR  INCCA
	CONT	ZB  ADD CIN  RAMF B=sp
	CONT	ZA A=g  OR  RAMF B=d
	CJP	copyFetch  ZB  ADD CIN  RAMF B=g
	CONT	DA D=BR, 1 A=g  ADD  RAMF B=g  CWR

consl1:
	CONT	NZ  DQ D=BR, constag SHL3  EXOR
	CJP	LC, Fail  ZB  ADD CIN  RAMF B=d

	CONT	ZA A=sp  ADD CIN  ALDCA
	CONT	ZB  ADD CIN  RAMF B=sp
	CONT	ZA A=d  OR  CWR  INCCA
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=d
	CONT	ZB  ADD CIN  RAMF B=sp  D=BR,1  CWR
	CJP	matchFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
	CJV	NZ  DA D=BR,3 A=pc  AND
	
fix084:
	JUMP	mfexit
	CONT	DZ D=BR, 84  OR  QREG
//----------

ENTRY	matchmode + lastfunctor

	/*
		R0 = *D;
		deref(R0);
		if (tag (R0) == UNDEF)
		{
			in_trail (R0);
			memoff0(R0) = makeword (TERM, (int) G);
			*G++ = *(XC + CLAUSELEN + *PC++);
			D = G;
			G += *PC++;
			checkglobal (10);
			goto CopyMode;
		}
		if (tag (R0) != TERM) goto Fail;
		if (termfunctor (R0) != *(XC + CLAUSELEN + *PC++) goto Fail;
		PC++;
		D = (int *) val (R0) + 1;
		goto MatchMode;
	*/

	CONT	DZ D=BR, undeftag SHL3  OR  RAMA A=d B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DZ MASK  OR  RAMA A=ir0 B=R3
	CONT	DA D=BR, clauselen A=R3  ADD  RAMF B=R3
	CONT	AB A=xc B=R3  ADD  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	mbackup  RD
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJP	NZ, lfunc1  AQ A=R2  EXOR
	CJS	NLC, in_trail  DZ D=BUS  OR  RAMF B=R3
	LDCT	mbackup
rst093:
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  LVAR
	CONT	DA D=BR, termtag SHL3  A=g  OR  RAMF B=R1
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix093  ZA A=R1  OR  LBR  WR
rst094:
	CONT	ZB  ADD CIN  RAMA A=g B=g  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix094  ZA A=R3  OR  LBR  WR
	CONT	ZA A=g  OR  RAMF B=d
	CONT	DZ  MASK  OR  RAMA A=ir0 B=R0
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CJS	checkGlobal  AB A=R0  ADD  RAMF B=g
	CONT	DZ D=BR, 10  OR  RAMF B=R0
	JUMP	copyFetch1  ZB  ADD CIN  RAMF B=pc
	CONT	DZ RTR1  OR  RAMA A=ir0  B=ir0  LDIR
lfunc1:
	CONT	NZ  DQ D=BR, termtag SHL3  EXOR
	CJP	LC, Fail
rst095:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix095  RD
	CONT
	CJP	NZ, Fail  DA D=BUS A=R3  EXOR
	CONT
	CONT	DZ RTR1  OR  RAMA A=ir0 B=ir0
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=d
	JUMP	matchFetch  ZB  ADD CIN  RAMF B=d
	CONT	ZB  ADD CIN  RAMF B=pc
	
fix093:
	JUMP	mfexit
	CONT	DZ D=BR, 93  OR  QREG
	
fix094:
	JUMP	mfexit  ZB  SUBR  RAMF B=g
	CONT	DZ D=BR, 94  OR  QREG
	
fix095:
	JUMP	mfexit
	CONT	DZ D=BR, 95  OR  QREG
//----------

ENTRY	matchmode + lastconslist

	/*
		R0 = *D;
		deref(R0);
		if (tag (R0) == UNDEF)
		{
			checkglobal (12);
			in_trail (R0);
			memoff0(R0) = makeword (CONS, (int) G);
			D = G;
			G += 2;
			goto CopyMode;
		}
		if (tag (R0) != CONS) goto Fail;
		D = (int *) val (R0);
		goto MatchMode;
	*/

	CONT	DZ D=BR, undeftag SHL3  OR  RAMA A=d B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJP	NZ, lconsl1  AQ A=R2  EXOR
	CJS	NLC, checkGlobal  ZA A=R0  OR  RAMF B=R2
	CONT	DZ D=BR, 12  OR  RAMF B=R0
	CJS	in_trail
	LDCT	mpnoop  ZA A=R2  OR  RAMF B=R0
rst085:
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  LVAR
	CONT	DA D=BR, constag SHL3  A=g  OR  RAMF B=R1
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix085  ZA A=R1  OR  LBR  WR
	JUMP	copyFetch  ZA A=g  OR  RAMF B=d
	CONT	DA D=BR, 2 A=g  ADD  RAMF B=g
lconsl1:
	CONT	NZ  DQ D=BR, constag SHL3  EXOR
	CJP	LC, Fail
	CJP	NLC, matchFetch
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=d
	
fix085:
	JUMP	mfexit
	CONT	DZ D=BR, 85  OR  QREG
//----------

ENTRY	matchmode + immed

	/*
		R1 = makeword (INT, (*PC++ & 0xff));
		goto ConstMatch;
	*/

	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, inttag SHL3   A=R0  OR  RAMF B=R1
	CJP	ConstMatch  DZ  RTR1  OR  RAMA A=ir0 B=ir0
	CONT	ZB  ADD CIN  RAMF B=pc
//----------

ENTRY	matchmode + constnil

	/*
		R1 = syswords[SWNIL];
		goto ConstMatch;
	*/

	CONT	DZ D=BR, pswapbase + syswords  OR  ALDCA
	CONT	DZ D=BR, swnil  OR  RAMF B=R0
	CONT	DA D=CSH A=R0  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	mpnoop  RD
	JUMP	ConstMatch
	CONT	DZ D=BUS  OR  RAMF B=R1
//----------

ENTRY	matchmode + constant

	/*
		R1 = *(XC + CLAUSELEN + *PC++);
	ConstMatch:
		R0 = *D++;
		deref (R0);
		if (tag (R0) == UNDEF)
		{
			in_trail (R0);
			memoff0 (R0) = R1;
		}
		else if (R0 != R1) goto Fail;
		goto MatchMode;
	*/

  	CONT	DZ MASK  OR  RAMA A=ir0 B=R0
	CONT	DA D=BR, clauselen A=R0  ADD  RAMF B=R0
	CONT	AB A=xc  ADD  RAMF B=R0  LVAR
	CONT	ZB  ADD CIN  RAMF B=pc  D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ  RTR1  OR  RAMA A=ir0 B=ir0  LOCK
	LDCT	mbackup  RD
	CONT
	CONT	DZ D=BUS  OR  RAMF B=R1
ConstMatch:
rst096:
	CONT	ZB  ADD CIN  RAMA A=d B=d  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix096  RD
	CJS	dref
	CONT	DZ D=BUS  OR  RAMF B=R0
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	NZ  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, const1
	CJS	NLC, in_trail
	LDCT	fix096
rst097:	
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJP	NWFLT, matchFetch  LOCK
	CJS	NLC, wcache  ZA A=R1  OR  LBR  WR
	LDCT	fix097
	JUMP	matchFetch2  DZ RTR1  OR  RAMA A=ir0  B=ir0  ALDIR
	CJV	NZ  DA D=BR,3 A=pc  AND

const1:
	CJP	NZ, Fail  AB A=R0 B=R1  EXOR
	CJP	NLC, matchFetch
	CONT
	
fix096:
	JUMP	mfexit  ZB  SUBR  RAMF B=d
	CONT	DZ D=BR, 96  OR  QREG
	
fix097:
	JUMP	mfexit
	CONT	DZ D=BR, 97  OR  QREG
//----------

