/*
	xpzip.m
	
	Copyright (c) 1986, 1987 by High Level Hardware Limited
*/

*I opcodes.m
*I proregs.m
*I proops.m
*I proconsts.m

GLOBAL	checkGlobal, fatality, processorTrap, in_trail, dref, drefR1
GLOBAL	checkLocal, untrail, unify
GLOBAL	claimclause, in_unatomic
GLOBAL	rst005, rst043
GLOBAL	rst065, rst066, rst067, rst068, rst069
GLOBAL	rst070, rst071, rst072, rst073, rst074, rst075, rst077
GLOBAL  rst078, rst079
GLOBAL	rst100, rst101, rst102, rst103, rst104, rst105

EXTERNAL mexit, cexit, cfexit, copyFetch, fillIr0, nextmatch, matchFetch
EXTERNAL Fail, pctobyte
EXTERNAL rcache, wcache, rwcache, noop

in_unatomic:

	/*
		deref(R0);
		if (tag (R0) == UNDEF)
		{
			memoff0(R0) = R1;
			in_trail(R0);
		}
		else
		if (R0 != R1) goto Fail;
	*/

	CJS	dref
	CONT
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	Z  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, unat1
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  QREG  LVAR
	CRTN	Z  AB A=R0 B=R1  EXOR
	CJPP	NLC, Fail
	CONT
unat1:
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R1  OR  LBR  WR

// Fall through into in_trail

in_trail:

	/*
		IQ = (int *) val(w);
		if (((IQ > LORG) && (IQ < BL)) || (IQ < *(BL+GOFF)))
		{
			*TR++ = w;
			if (tr>trtop)
				fatality(68);
		}
	*/

	CONT	DZ D=BR, pswapbase+lorg  OR  ALDCA
	CONT	DA D=BR, tagmask SHL3  A=R0  NOTRS  QREG
	CJP	NBW, @1  DQ D=CSH  SUB CIN
	CONT	DA D=BR, goff  A=bl  ADD  LVAR
	CJP	BW, @2  AQ A=bl  SUBR CIN
@1:
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	CONT
	CRTN	NBW  DQ D=BUS  SUBR CIN
@2:
	CONT	ZA A=tr  OR  LVAR
	CONT	D=TB  LBR  ADDR		
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R0  OR  LBR  WR
	CONT	DZ D=BR, pswapbase+trtop  OR  ALDCA
	CONT	ZB  ADD CIN  RAMF B=tr

	CRTN	NBW  DA D=CSH A=tr  SUB CIN
	CJPP	NLC, fatality
	CONT	DZ D=BR, 68  OR  RAMF B=R0
//----------

untrail:
	/*
		if (TR > TR1)
		{
			IP = TR;
			while (IP > TR1)
			{
				R0 = *--IP;
				if (tag (R0) == UNDEF) mem (val (R0)) = R0;
				else
				{
					proctrap ((tag (R0) != CLAUSE), 50);
					IQ = (int *) val (R0) + CLAFLAOFF;
					R2 = *IQ;
					*IQ = R2 & ~CFCLAIMED;
					if ((R2 & CFDOOMED) && 
						!(R2 & CFREFMASK))
							dealloc (R0);
				}
			}
			TR = IP;
		}
	*/

	CJP	NBW, untrail1  AB A=R1 B=tr  SUB CIN
	CONT
	CONT	ZA A=tr  OR  RAMF B=ip
untrloop:
rst005:
		CJP	NBW, untrail2  AB A=R1 B=ip  SUB CIN
		CONT	ZA A=ip  SUBR  LVAR
		CONT	D=TB  LBR  ADDR
		CJS	RFLT, rcache  LOCK
		LDCT	fix005  RD
		CONT	DZ D=BR, tagmask SHL3  OR  RAMF B=R0
		CONT	DA D=BUS A=R0  AND  QREG
		CONT	NZ DQ D=BR, undeftag SHL3  EXOR
		CJP	LC, untrail3  DZ D=BUS  OR  RAMF B=R0
		CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
		CONT	ZB  SUBR  RAMF B=ip  D=TB  LBR  ADDR
		CJP	NWFLT, untrloop  LOCK
		CJS	NLC, wcache  ZA A=R0  OR  LBR  WR
		LDCT	fix005  ZB  ADD CIN  RAMF B=ip
		JUMP	untrloop  ZB  SUBR  RAMF B=ip
		CONT
untrail3:
		CONT	NZ  DQ D=BR, clausetag SHL3  EXOR
		CJP	LC, processorTrap  ZA A=R0  OR  RAMF B=R3
		CONT	DZ D=BR, 50  OR  RAMF B=R0
		CONT	DA D=BR, tagmask SHL3 A=R3  NOTRS  RAMF B=R0
		CONT	ZB  SUBR  RAMF B=ip
rst043:
		CONT	DA D=BR, claflaoff A=R0  ADD  LVAR
		CONT	D=TB  LBR  ADDR
		CJS	WFLT, rwcache  LOCK
		LDCT	fix043  RD
		CONT	DZ D=BR, cfclaimed  SUBR  RAMF B=R0  LOCK
		CONT	DA D=BUS A=R0  AND  RAMF B=R0  LOCK
		CONT	ZA A=R0  OR  LBR  WR
		CONT	DZ D=BUS  OR  RAMF B=R0
		CONT	Z  DA D=BR, cfdoomed A=R0  AND
		CJP	LC, untrloop
		CONT	NZ  DA D=BR, cfrefmask SHL2 A=R0  AND
		CJP	LC, untrloop
		LDCT	cexit  ZA A=R3  OR  RAMF B=R0
		JRP	F  DZ D=BR, deallocCode SHL1  OR  QREG
		CONT	DQ D=BR, 05  OR  QREG
untrail2:
	CONT	ZA A=ip  OR  RAMF B=tr	
untrail1:
	CONT	ZA A=R2  OR  LDIR
	CJV
	CONT

fix005:
	JUMP	cfexit
	CONT	DZ D=BR, 05  OR  QREG
fix043:
	JUMP	cfexit
	CONT	DZ D=BR, 43  OR  QREG
//----------

claimclause:

	/*
		IP = XC + CLAFLAOFF;
		if (!(*IP & CFCLAIMED))
		{
			*IP |= CFCLAIMED;
			*TR++ = makeword (CLAUSE, (int) XC);
			if (TR > TRTOP) fatality (68);
		}
	*/

	CONT	DA D=BR, claflaoff A=xc  ADD  RAMF B=ip  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, rwcache  LOCK
	CONT	RD
	CONT	DZ D=BR, cfclaimed  OR  RAMF B=R2
	CJP	NZ, @1  DA D=BUS A=R2  AND
	CONT	DA D=BUS A=R2  OR  RAMF B=R0
 
	CONT	DA D=BR, clausetag SHL3  A=xc  OR  RAMF B=R2
	CONT	ZA A=tr  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R2  OR  LBR  WR
	CONT	ZB  ADD CIN  RAMA A=ip B=tr  LVAR
	CONT	D=TB  LBR  ADDR
	// Cannot fault but may need to recache
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R0  OR  LBR  WR
	CONT	DZ D=BR, pswapbase+trtop  OR  ALDCA  LOCK
	CONT
	CJP	BW, fatality  DA D=CSH A=tr  SUB CIN
	CONT	DZ D=BR, 68  OR  RAMF B=R0
@1:
	/*
		if (tag (M0) != TERMIN)
		{
			IP = (int *) (val (M0)) + CLAFLAOFF;
			if (!(*IP & CFCLAIMED))
			{
				*IP |= CFCLAIMED;
				*TR++ = M0;
				if (TR > TRTOP) fatality (68);
			}
		}
	*/

	CONT	DA D=BR, tagmask SHL3  A=m0  AND  RAMF B=R0
	CRTN	Z  DA D=BR, termintag SHL3 A=R0  EXOR
	CONT	DA D=BR, tagmask SHL3 A=m0  NOTRS  RAMF B=ip
	CONT	DA D=BR, claflaoff A=ip  ADD  RAMF B=ip  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, rwcache  LOCK
	CONT	RD
	CONT	DZ D=BR, cfclaimed  OR  RAMF B=R2
	CRTN	NZ  DA D=BUS A=R2  AND
	CONT	DA D=BUS A=R2  OR  RAMF B=R0
 
	CONT	ZA A=tr  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=m0  OR  LBR  WR
	CONT	ZB  ADD CIN  RAMA A=ip B=tr  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	CONT	ZA A=R0  OR  LBR  WR
	CONT	DZ D=BR, pswapbase+trtop  OR  ALDCA
	CONT
	CRTN	NBW  DA D=CSH A=tr  SUB CIN
	CJPP	NLC, fatality
	CONT	DZ D=BR, 68  OR  RAMF B=R0
//----------

unify:
	/*
		deref (R0);
		deref (R1);
		if (R0 == R1) goto CopyMode;
		if (tag(R0) == UNDEF)
		{
			if (tag (R1) == UNDEF)
			{
				if (val (R1) < val (R0))
				{
					R1 = makeword (LINK, val(R1));
					goto R0var;
				}
				R0 = makeword (LINK, val(R0));
				goto R1var;
			}
	R0var:
			memoff0(R0) = R1;
			in_trail(R0);
			goto CopyMode;
		}
		if (tag (R1) == UNDEF)
		{
	R1var:
			memoff0(R1) = R0;
			in_trail (R1);
			goto Copymode;
		}
	*/
rst065:
	CJS	dref	
	LDCT	fix065
	CJS	drefR1
	LDCT	fix065
	CJP	Z, unifyTrue  AB A=R0 B=R1  EXOR
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CONT	NZ  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, unify1
	CONT	DA D=BR, tagmask SHL3 A=R1  AND  QREG
	CONT	NZ  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, unify2
	CONT
	CJP	BW, unify3  AB A=R1 B=R0  SUB CIN
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  QREG
	JUMP	R1var
	CONT	DQ D=BR, linktag SHL3  OR  RAMF B=R0
unify3:	
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  QREG
	CONT	DQ D=BR, linktag SHL3  OR  RAMF B=R1
unify2:
R0var:
rst066:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix066  ZA A=R1  OR  LBR  WR
	CJS	in_trail
	CONT
	JUMP	unifyTrue
	CONT
unify1:
	CONT	DA D=BR, tagmask SHL3 A=R1  AND  QREG
	CONT	NZ  DQ D=BR, undeftag SHL3  EXOR
	CJP	LC, unify4
R1var:
rst067:
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix067  ZA A=R0  OR  LBR  WR
rst075:
	CJS	in_trail  ZA A=R1  OR  RAMF B=R0
	LDCT	fix075
	JUMP	unifyTrue
	CONT
unify4:

	CONT	DZ D=BR, pswapbase+savepc  OR  ALDCA
	CONT	ZA A=pc  OR  CWR  INCCA
	CONT	ZA A=xc  OR  CWR  INCCA
	CONT	ZA A=ir0  OR  CWR  INCCA
	CONT	ZA A=R2  OR  CWR
	CONT	DZ D=BR, 1  OR  RAMF B=URc
	CONT	ZA A=g OR RAMF B=ip
	CONT	ZA A=g OR RAMF B=URbot
unifyloop:
rst068:
	CJS	dref
	LDCT	fix068
	CJS	drefR1
	CONT	
	CJP	Z, unify5  AB A=R1 B=R0  EXOR
	CONT	DZ D=BR, pswapbase+unifytable  OR  ALDCA
	CONT	DZ ZZZA  OR  RAMA A=R1 B=R2
	CONT	ZB  OR  RAMD B=R2
	CONT	ZB  OR  RAMD B=R2
	CONT	ZB  OR  RAMD B=R2
	CONT	ZB  OR  RAMD B=R2
	CONT	ZA A=R2  OR  QREG
	CONT	DZ ZZZA  OR  RAMA A=R0 B=R2
	CONT	DA D=BR, 0F0H A=R2  AND  RAMF B=R2
	CONT	AQ A=R2  OR  RAMF B=R2
	CONT	DA D=CSH A=R2  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix068  RD
	CONT
	CJP	Z, case0  DZ D=BUS  OR  QREG
	CJP	Z, case1  ZQ  SUBR  QREG
	CJP	Z, case2  ZQ  SUBR  QREG
	CJP	Z, case3  ZQ  SUBR  QREG
	CJP	Z, case4  ZQ  SUBR  QREG
	CJP	Z, case5  ZQ  SUBR  QREG
	CJP	Z, case6  ZQ  SUBR  QREG
	CJP	Z, case7  ZQ  SUBR  QREG
	CJP	Z, case8  ZQ  SUBR  QREG
	CJP	Z, case9  ZQ  SUBR  QREG
	CJP	Z, case10  ZQ  SUBR  QREG
	CJP	NLC, unify5
	CONT

case0:
  	CONT	DZ D=BR, pswapbase+savepc  OR  ALDCA
	CONT	DZ D=BR,14  OR  RAMF B=R0  INCCA
	CONT	DZ D=CSH  OR  RAMF B=pc  INCCA
	JUMP	processorTrap  DZ D=CSH  OR  RAMF B=xc
	CONT	DZ D=CSH  OR  RAMF B=ir0

case1:
	/*
		if (val (R1) < val (R0))
		{
			memoff0 (R0) = makeword (LINK, val (R1));
			in_trail (R0);
		}
		else
		{
			memoff0 (R1) = makeword (LINK, val (R0));
			in_trail (R1);
		}
	*/

rst069:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R2
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  QREG
	CJP	NBW, @1  AQ A=R2  SUBR CIN
	CONT	ZA A=R2  OR  LVAR
	CONT	DQ D=BR, linktag SHL3  OR  QREG
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix069  ZQ  OR  LBR  WR	
	CJS	in_trail
	CONT
	JUMP	unify5
	CONT
@1:
	CONT	DA D=BR, linktag SHL3 A=R2  OR  RAMF B=R2
	CONT	ZQ  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix069  ZA A=R2  OR  LBR  WR	
rst070:
	CJS	in_trail
	LDCT	fix070  ZA A=R1  OR  RAMF B=R0
	JUMP	unify5
	CONT
case2:
	/*
		memoff0 (R0) = R1;
		in_trail (R0);
	*/

rst071:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix071  ZA A=R1  OR  LBR  WR	
	CJS	in_trail
	CONT
	JUMP	unify5
	CONT
case3:
	/*
		memoff0 (R1) = R0;
		in_trail (R1);
	*/

rst072:
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix072  ZA A=R0  OR  LBR  WR	
rst073:
	CJS	in_trail
	LDCT	fix073  ZA A=R1  OR  RAMF B=R0
	JUMP	unify5
	CONT
case4:
	/*
		if (termfunctor (R0) != termfunctor (R1)) return (FALSE);
		if (URc > 1)
		{
			*++IP = URa;
			*++IP = URb;
			*++IP = URc;
		}
		URa = adroff (val (R0), 1);
		URb = adroff (val (R1), 1);
		URc = termarity (R0);
		R0 = mem (URa);
		R1 = mem (URb);
		continue;
	*/

rst078:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix078  RD
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK
	LDCT	fix078  RD
	CONT
	CJP	NZ, unifyFalsetemp  DA D=BUS A=R2  EXOR
	CONT	NBW  DA D=BR, 1 A=URc  SUB CIN
	CJP	LC, @1  ZA A=ip  ADD CIN   LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix078  ZA A=URa  OR  LBR  WR
	CONT	DA D=BR, 2 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix078  ZA A=URb  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix078  ZA A=URc  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  RAMF B=ip
@1:
rst079:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R2
	CONT	ZA A=R2  ADD CIN  RAMF B=URa
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R2
	CONT	ZA A=R2  ADD CIN  RAMF B=URb
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix079  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  QREG
	CONT	DQ D=BUS  AND  QREG
	CONT	DQ D=BR, funaroff  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix079  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMA A=URa B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DA D=BUS A=R2  AND  RAMF B=URc  LOCK
	LDCT	fix079  RD
	CONT	ZA A=URb  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK
	LDCT	fix079  RD
	JUMP	unifyloop  ZA A=R2  OR  RAMF B=R0
	CONT	DZ D=BUS  OR  RAMF B=R1

case5:
	/*
		if (boxcmp (val (R0), val (R1)) == FALSE) return (FALSE);
	*/

rst104:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R0  LVAR
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R1
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix104  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMF B=R2
	CONT	DA D=BUS A=R2  AND  RAMF B=R2
	CONT	ZB  SUBR  RAMD B=R2
	CONT	DA D=BR, 4 A=R2  ADD  RAMD B=R2
case5loop:
rst105:
	CJP	Z, unify5  ZB  OR  RAMA A=R0 B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix105  RD
	CONT	ZA A=R1  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  QREG  LOCK
	LDCT	fix105  RD
	CONT	ZB  SUBR  RAMF B=R2
	CJP	NZ, unifyFalsetemp  DQ D=BUS  EXOR
	CJP	NLC, case5loop  ZB  ADD CIN  RAMF B=R0
	CONT	ZB  ADD CIN  RAMF B=R1

case9:
	/*
		if (URc > 1)
		{
			*++IP = URa;
			*++IP = URb;
			*++IP = URc;
		}
		URa = val (R0);
		URb = val (R1);
		URc = 2;
		R0 = mem (URa);
		R1 = mem (URb);
		continue;
	*/

rst102:
	CONT	NBW  DA D=BR, 1 A=URc  SUB CIN
	CJP	LC, @1  ZA A=ip  ADD CIN   LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix102  ZA A=URa  OR  LBR  WR
	CONT	DA D=BR, 2 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix102  ZA A=URb  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix102  ZA A=URc  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  RAMF B=ip
@1:
rst103:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=URa
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=URb
	CONT	DZ D=BR, 2  OR  RAMA A=URa  B=URc  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix103  RD
	CONT	ZA A=URb  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK
	LDCT	fix103  RD
	JUMP	unifyloop  ZA A=R2  OR  RAMF B=R0
	CONT	DZ D=BUS  OR  RAMF B=R1
	
case10:
	/*
		if (tablesize (R0) != tablesize (R1)) return (FALSE);
		if (URc > 1)
		{
			*++IP = URa;
			*++IP = URb;
			*++IP = URc;
		}
		URa = adroff (val (R0), 1);
		URb = adroff (val (R1), 1);
		URc = tablesize (R0);
		R0 = mem (URa);
		R1 = mem (URb);
		continue;
	*/

rst100:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix100  RD
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK
	LDCT	fix100  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  QREG
	CONT	DA D=BUS A=R2  EXOR  RAMF B=R2
	CJP	NZ, unifyFalsetemp  AQ A=R2  AND
	CONT	NBW  DA D=BR, 1 A=URc  SUB CIN
	CJP	LC, @1  ZA A=ip  ADD CIN   LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix100  ZA A=URa  OR  LBR  WR
	CONT	DA D=BR, 2 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix100  ZA A=URb  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	WFLT, wcache  LOCK
	LDCT	fix100  ZA A=URc  OR  LBR  WR
	CONT	DA D=BR, 3 A=ip  ADD  RAMF B=ip
@1:
rst101:
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  RAMF B=R2
	CONT	ZA A=R2  ADD CIN  RAMF B=URa
	CONT	DA D=BR, tagmask SHL3 A=R1  NOTRS  RAMF B=R2
	CONT	ZA A=R2  ADD CIN  RAMF B=URb
	CONT	DA D=BR, tagmask SHL3 A=R0  NOTRS  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix101  RD
	CONT	DZ D=BR, tagmask SHL3  SUBR  RAMA A=URa B=R2  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DA D=BUS A=R2  AND  RAMF B=URc  LOCK
	LDCT	fix101  RD
	CONT	ZA A=URb  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R2  LOCK
	LDCT	fix101  RD
	JUMP	unifyloop  ZA A=R2  OR  RAMF B=R0
	CONT	DZ D=BUS  OR  RAMF B=R1

unify5:
	/*
		if (--URc == 0)
		{
			if (IP == URbot) return TRUE;
			URc = (*IP--) - 1;
			URb = *IP--;
			URa = *IP--;
		}
	*/

	CJP	NZ, unify6  ZB  SUBR  RAMF B=URc
	CONT
	CJP	Z, unifyTruetemp  AB A=ip B=URbot  EXOR
rst074:
	CONT	ZA A=ip  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix074  RD
	CONT	ZA A=ip  SUBR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  SUB  RAMF B=URc  LOCK
	LDCT	fix074  RD
	CONT	DA D=BR, 2 A=ip  SUBR CIN  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=URb  LOCK
	LDCT	fix074  RD
	CONT	DA D=BR, 3 A=ip  SUBR CIN  RAMF B=ip
	CONT	DZ D=BUS  OR  RAMF B=URa
unify6:
	/*
		URa = adroff (URa, 1);
		URb = adroff (URb, 1);
		R0 = mem(URa);
		R1 = mem(URb);
	*/

	CONT	ZA A=URa  ADD CIN  RAMF B=URa
	CONT	ZA A=URb  ADD CIN  RAMF B=URb
rst077:
	CONT	ZA A=URa  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fix077  RD
	CONT	ZA A=URb  OR  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  DZ D=BUS  OR  RAMF B=R0  LOCK
	LDCT	fix077  RD
	JUMP	unifyloop
	CONT	DZ D=BUS  OR  RAMF B=R1

case6:
case7:
case8:
unifyFalsetemp:
  	CONT	DZ D=BR, pswapbase+savepc  OR  ALDCA
	CONT	INCCA
	CONT	DZ D=CSH  OR  RAMF B=pc  INCCA
	JUMP	Fail  DZ D=CSH  OR  RAMF B=xc
	CONT	DZ D=CSH  OR  RAMF B=ir0

unifyTruetemp:
	CONT	DZ D=BR, pswapbase+savepc  OR  ALDCA
	CONT	INCCA
	CONT	DZ D=CSH  OR  RAMF B=pc  INCCA
	CONT	DZ D=CSH  OR  RAMF B=xc  INCCA
	CONT	DZ D=CSH  OR  RAMF B=ir0
	CONT	DZ D=CSH  OR  RAMF B=R2
unifyTrue:
	CJP	Z, copyFetch  ZA A=R2  OR
	CJP	NLC, matchFetch
	CONT

	
fix065:
	JUMP	cfexit
	CONT	DZ D=BR, 65  OR  QREG

fix066:
	JUMP	cfexit
	CONT	DZ D=BR, 66  OR  QREG

fix067:
	JUMP	cfexit
	CONT	DZ D=BR, 67  OR  QREG

fix068:
	JUMP	cfexit
	CONT	DZ D=BR, 68  OR  QREG

fix069:
	JUMP	cfexit
	CONT	DZ D=BR, 69  OR  QREG

fix070:
	JUMP	cfexit
	CONT	DZ D=BR, 70  OR  QREG

fix071:
	JUMP	cfexit
	CONT	DZ D=BR, 71  OR  QREG

fix072:
	JUMP	cfexit
	CONT	DZ D=BR, 72  OR  QREG

fix073:
	JUMP	cfexit
	CONT	DZ D=BR, 73  OR  QREG

fix074:
	JUMP	cfexit
	CONT	DZ D=BR, 74  OR  QREG

fix075:
	JUMP	cfexit
	CONT	DZ D=BR, 75  OR  QREG

fix077:
	JUMP	cfexit
	CONT	DZ D=BR, 77  OR  QREG

fix078:
	JUMP	cfexit
	CONT	DZ D=BR, 78  OR  QREG

fix079:
	JUMP	cfexit
	CONT	DZ D=BR, 79  OR  QREG

fix100:
	JUMP	cfexit
	CONT	DZ D=BR, 100  OR  QREG

fix101:
	JUMP	cfexit
	CONT	DZ D=BR, 101  OR  QREG

fix102:
	JUMP	cfexit
	CONT	DZ D=BR, 102  OR  QREG

fix103:
	JUMP	cfexit
	CONT	DZ D=BR, 103  OR  QREG

fix104:
	JUMP	cfexit
	CONT	DZ D=BR, 104  OR  QREG

fix105:
	JUMP	cfexit
	CONT	DZ D=BR, 105  OR  QREG
//----------
	
checkGlobal:

/* performs the code 'if ((G + e > GTOP) fatality(66)'
   entry -  R0 <- e
   exit  -  just returns if ok, otherwise goes to fatality with rel. code
*/

	CONT	DZ D=BR, pswapbase+gtop  OR  ALDCA
	CONT	AB A=g  ADD  RAMF B=R0
	CRTN	NBW  DA D=CSH A=R0  SUB CIN
	CJPP	NLC, fatality
	CONT	DZ D=BR, 66  OR  RAMF B=R0
//----------
	
checkLocal:

/* performs the code 'if ((L + e > LTOP) fatality(69)'
   entry -  R0 <- e
   exit  -  just returns if ok, otherwise goes to fatality with rel. code
*/

	CONT	DZ D=BR, pswapbase+ltop  OR  ALDCA
	CONT	AB A=l  ADD  RAMF B=R0
	CRTN	NBW  DA D=CSH A=R0  SUB CIN
	CJPP	NLC, fatality
	CONT	DZ D=BR, 69  OR  RAMF B=R0
//----------
	
fatality:
/*
   enter with a fatality code in R0, set the fatality bit and exit
   after stuffing the code into QREG
*/

	JUMP	cexit  DZ SHL2  OR  RAMA A=R0 B=R0
	CONT	DA D=BR, fatalBit A=R0  OR  QREG
//----------

processorTrap:
/* similar to fatality, except sets the procTrap bit
   R0 is the trap code
*/

	JUMP	cexit  DZ SHL2  OR  RAMA A=R0 B=R0
	CONT	DA D=BR, trapBit A=R0  OR  QREG
//----------

dref:
	/*
		{
			while (tag(r)==LINK)
				 r = *((int *) val(r));
		}
	*/

	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CRTN	NZ  DQ D=BR, linktag SHL3  EXOR
	CONT	DA D=BR, tagmask SHL3  NOTRS A=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	JUMP	dref
	CONT	DZ D=BUS  OR  RAMF B=R0

drefR1:
	CONT	DA D=BR, tagmask SHL3 A=R1  AND  QREG
	CRTN	NZ  DQ D=BR, linktag SHL3  EXOR
	CONT	DA D=BR, tagmask SHL3  NOTRS A=R1  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	CONT	RD
	JUMP	drefR1
	CONT	DZ D=BUS  OR  RAMF B=R1
//----------

ENTRY	umode + deref

	CONT	DZ D=CSH  OR  RAMF B=R0
	CONT	DZ SHR1  OR  RAMA A=ir0 B=ir0  LDIR
@1:
	CONT	DA D=BR, tagmask SHL3 A=R0  AND  QREG
	CJV	NZ  DQ D=BR, linktag SHL3  EXOR
	CONT	ZA A=R0  OR  CWR
	CONT	DA D=BR, tagmask SHL3  NOTRS A=R0  LVAR
	CONT	D=TB  LBR  ADDR
	CJS	RFLT, rcache  LOCK
	LDCT	fixup  RD
	JUMP	@1
	CONT	DZ D=BUS  OR  RAMF B=R0

fixup:
	CONT	DZ  SHL1  OR  RAMA A=ir0 B=ir0
	JUMP	noop  DA D=CAIR MASK A=ir0  OR  RAMF B=ir0
	CONT	DZ D=BR, deref  OR  LDIR
//----------
