/* alloc.c:  memory allocation */


#include "zip.h"

extern int *H, *G, *GTOP;

/* allocate n words from the global stack */

int *alloc(n)
register int n;
{
  register int *i;
  i = G;
  G += n;
  if (G > GTOP) fatality(66);
  return(i);
}


/*  allocate c words from the heap */

int *getheap(c)
int c;
/* K is a fractination constant */
#define K 3
{
  register int *p, *p1, *b, s;
/*
display("getheap",c);
*/
  p = H;
  while (p != 0)
  {
    s = *(p+FRECOUOFF);
    if (s == c)
    {
      p1 = (int *) *(p+FRELINOFF);
      if (p == H) H = p1; else *(b+FRELINOFF) = (int) p1;
/*
display("found same size",c);
*/
      return(p);
    }
    else if (s >= c + K)
    {
      p1 = p + c;
      if (p == H) H = p1; else *(b+FRELINOFF) = (int) p1;
      *(p1+FRELINOFF) = *(p+FRELINOFF);
      *(p1+FRECOUOFF) = *(p+FRECOUOFF) - c;
      return(p);
    }
    else
    {
      b = p;
      p = (int *) *(p+FRELINOFF);
    }
  }
  fatality(67);
}


/* free the cell at p having size c */

freecell(p,c)
int *p, c;
{
  int *f, *b;
/*
display("freecell, size",c);
*/
  f = H;
  while (f < p)
  {
    b = f;
    f = (int *) *(f+FRELINOFF);
  }
  *(p+FRELINOFF) = (int) f;
  *(p+FRECOUOFF) = c;
  if (f == H)  H = p;
  else
  {
    *(b+FRELINOFF) = (int)  p;
    if (p == (b + *(b+FRECOUOFF)))
    {
/*
display("merge lower block",0);
*/
      *(b+FRELINOFF) = *(p+FRELINOFF);
      *(b+FRECOUOFF) = *(b+FRECOUOFF) + c;
      p = b;
      c = *(p+FRECOUOFF);
    }
  }
  if ((p + c) == f)
  {
/*
display("merge upper block",0);
*/
    *(p+FRELINOFF) = *(f+FRELINOFF);
    *(p+FRECOUOFF) = c + *(f+FRECOUOFF);
  }
}


/* deallocate an entire structure. Allowed structures are
   boxes, terms, tables, and single clause cells (already unlinked).
   Danger:  this routine is recursive and should be rewritten as iterative.
   It should be safe as large ground terms are not in the heap at the moment.
   When deallocating an XR table, decrement the ref counts of clauses
   referenced, and deallocate if possible (they will have been unlinked).
*/

static unref(w)
int w;
{
  register int *fp, f, c;
  fp = (int *) val(w) + CLAFLAOFF;
  f = *fp;
  c = (f & CFREFMASK) - CFREFINC;
  if (!c && (f & CFDOOMED) && !(f & CFCLAIMED)) dealloc(w);
  else *fp = (f & ~CFREFMASK) | c;
}


dealloc(w)
register int w;
{
  register int a, i, r;
/*
display("dealloc called on",w);
*/
  switch(tag(w))
  {
    case BOX:
      freecell((int *) val(w), blocksize(blockchars(w)));
      break;
    case TERM:
      a = termarity(w);
      for (i = 1; i <= a; i++) dealloc(memoff(w,i));
      freecell((int *) val(w),a+1);
      break;
    case TABREF:
      a = tablesize(w);
      for (i = 1; i < a; i++)
      {
        r = memoff(w,i);
        if (tag(r) == CLAUSE) unref(r); else dealloc(r);
      }
      freecell((int *) val(w),a);
      break;
    case CLAUSE:
      proctrap((memoff(w,CLABACOFF) != TERMIN),600);
/*
prclause(" deallocating",w);
*/
      dealloc(memoff(w,CLATEXOFF));
      a = clausesize(w);
       for (i = CLAUSELEN; i < a; i++)
      {
        r = memoff(w,i);
        if (tag(r) == CLAUSE) unref(r); else dealloc(r);
      }
      freecell((int *) val(w),a);
      break;
  }
}


/* Link a clause c into procedure t at end i */

linkclause(c,t,i)
int c,t,i;
{
  int f, g;
  if (i == 1)
  {
    f = memoff(t,PROCLAOFF);
    g = memoff(f,FIXFIROFF);
    if (tag(g) == TERMIN)
    {
      memoff(f,FIXFIROFF) = memoff(f,FIXLASOFF) = c;
      memoff(c,CLABACOFF) = f;
    }
    else
    {
      memoff(g,CLABACOFF) = c;
      memoff(c,CLABACOFF) = f;
      memoff(c,CLAFOROFF) = g;
      memoff(f,FIXFIROFF) = c;
    }
  }
  else if (i == 0)
  {
    f = memoff(t,PROCLAOFF);
    g = memoff(f,FIXLASOFF);
    if (tag(g) == TERMIN)
    {
      memoff(f,FIXFIROFF) = memoff(f,FIXLASOFF) = c;
      memoff(c,CLABACOFF) = f;
    }
    else
    {
      memoff(c,CLABACOFF) = g;
      memoff(g,CLAFOROFF) = memoff(f,FIXLASOFF) = c;
    }
  }
}


/*
  Unlink a clause t in unit time.  Clauses already unlinked will have
  TERMIN in their CLABACOFF, so will be ignored.
*/

unchain(t)
int t;
{
  int b, f;
  if (tag(t) == CLAUSE)
  {
    b = memoff(t,CLABACOFF);
    if (b == TERMIN) return;
/*
prclause(" unchain: ",t);
*/
    f = memoff(t,CLAFOROFF);
    if (tag(b) == TABREF)
    {
      if (tag(f) == CLAUSE)
      {
        memoff(f,CLABACOFF) = b;
        memoff(b,FIXFIROFF) = f;
      }
      else if (tag(f) == TERMIN)
      {
        memoff(b,FIXFIROFF) = TERMIN;
        memoff(b,FIXLASOFF) = TERMIN;
      }
    }
    else if (tag(b) == CLAUSE)
    {
      if (tag(f) == CLAUSE)
      {
        memoff(b,CLAFOROFF) = f;
        memoff(f,CLABACOFF) = b;
      }
      else if (tag(f) == TERMIN)
      {
        memoff(b,CLAFOROFF) = TERMIN;
        f = memoff(memoff(t,CLAPROOFF),PROCLAOFF);
        memoff(f,FIXLASOFF) = b;
      }
    }
    else return;
    memoff(t,CLABACOFF) = TERMIN;
    memoff(t,CLAFOROFF) = TERMIN;
  }
}
