/*  FILEIO.C:  Manipulating files and I/O.  Rehosted for C and UNIX */

#include "zip.h"

#define BUFFEMPTY (-2)      /* empty fileentry buff field */

/* the following externs are for the ZIP registers referenced by save/restore */

extern int BP;
extern int hash[], syswords[], modstk[], *modptr;
extern int *TR, *TR0, *L, *G0, *BL, *BG, *G, *CL, *CL0, *H;
extern char *CP;
extern int *LORG, *GORG, *HORG, *TRORG;

#define LENFILETAB	8
#define MAXFILETAB	&filetab[LENFILETAB-1]
#define USERSEE		&filetab[0]
#define USERTELL	&filetab[1]

fileentry filetab[LENFILETAB];
fileentry *currsee, *currtell;
FILE *image;		/* used only for heap image I/O */



/* initialise one file table entry (called by initIO and propenfile) */

static initfile(p,n,f,s,c,d)
int n,s,c,d;
FILE *f;
fileentry *p;
{
  p->see = s;
  p->buff = BUFFEMPTY;
  p->column = 1;
  p->line = 1;
  p->colmax = c;
  p->depmax = d;
  p->name = n;
  p->File = f;
}


/*  initialise the open file table */

initIO()
{
  fileentry *p;
  for (p = filetab; p <= MAXFILETAB; p++) p->name = TERMIN;
  initfile(USERSEE,syswords[SWUSER],stdin,TRUE,80,32);
  initfile(USERTELL,syswords[SWUSER],stdout,FALSE,80,32);
  currsee = USERSEE;
  currtell = USERTELL;
}


/*
  Convert a box b into a null terminated string s of total length l.
  Use the method of Procrustes.
*/

static boxtostring(b,s,l)
int b, l;
char *s;
{
  char *p;
  int c;
  c = blockchars(b);
  if (c >= l)  c = (l-1);
  p = (char *) (((int *) val(b)) + 1);
  while (c-- > 0)  *s++ = unconvch(*p++);
  *s = '\0';
}


/*  Open file not already open.  Return pointer to filetab or 0 */

static fileentry *propenfile(w,r)
int w, r;
{
  FILE *p;
  fileentry *f;
  char fn[64];
  f = filetab;
  while (f <= MAXFILETAB)
    if (tag(f->name) == TERMIN)
    {
      boxtostring(memoff(w,ATOCHOFF),fn,64);
      if ((p = fopen(fn, (r ? "r" : "w"))) == NULL) return(0);
      initfile(f,w,p,r,80,80000);
      return(f);
    }
    else f++;
  return(0);
}


/*  Implements seen/told */

prseentold(r)
int r;
{
  fileentry *p;
  p = (r ? currsee : currtell);
  if ((p == USERSEE) || (p == USERTELL))  return;
  fclose(p->File);
  p->name =  TERMIN;
  if (r)  currsee = USERSEE; else currtell = USERTELL;
}


/*  Check to see if a file is open.  Return pointer to filetab or 0 */

static fileentry *prisopen(w,r)
int w,r;
{
  fileentry *f;
  f = filetab;
  while (f <= MAXFILETAB) if (w == f->name && r == f->see) return(f); else f++;
  return(0);
}


/*  Implements see and tell */

int prseetell(w,r)
int w,r;
{
  fileentry *f;
  f = prisopen(w,r);
  if (f == 0) f = propenfile(w,r);
  if (f == 0)  return(FALSE);
  if (r)  currsee = f; else currtell = f;
  return(TRUE);
}


/*
  return and remove the next character from the current input stream.
  it is conventional to return CHPRNL (10) for newline, and CHPREOF (26 or 32)
  for end of file.
  Convert the character to implicit form if necessary.
*/

int getch()
{
  register int i;
  if (currsee->buff != BUFFEMPTY)
  {
    i = currsee->buff;
    currsee->buff = BUFFEMPTY;
    return(i);
  }
  i = getc(currsee->File);
  if (i == EOF)
  {
/*#ifdef BERK42 */
    clearerr(currsee->File);
/* #endif       */
    return(CHPREOF);
  }
  else if (i == CHNEWLINE)
  {
    (currsee->line)++;
    currsee->column = 0;
    return(CHPRNL);
  }
  else
  {
    (currsee->column)++;
    return(convch(i));
  }
}


/* return but do not remove the next character */

int peekch()
{
  if (currsee->buff == BUFFEMPTY)  currsee->buff = getch();
  return(currsee->buff);
}


/*  remove the character which has been peeked at */

skipch()
{
  currsee->buff = BUFFEMPTY;
}


/* write the character on the current output file */

putch(i)
register int i;
{
  if (i == CHPREOF) prseentold(FALSE);
  else if (i == CHPRNL)
  {
    putc(CHNEWLINE,currtell->File);
    (currtell->line)++;
    currtell->column = 0;
    fflush(currtell->File);
  }
  else
  {
    putc(unconvch(i),currtell->File);
    (currtell->column)++;
  }
}


/*
  Save a work image in the file named by box b.
  Not all registers are saved and restored.  As these routines return only
  from primhandle, XC, PC, PM, D are all initialised upon return.
  A better way to do this is to do direct block reads from memory.
*/

saveimage(b)
int b;
{
  register int i, *p, *q;
  char fn[64];
  boxtostring(b,fn,64);
#ifdef os370
  if ((image = fopen(fn,"w,binary")) == NULL) return(FALSE);
#else
  if ((image = fopen(fn,"w")) == NULL) return(FALSE);
#endif
  putword((int)TR);
  putword((int)L);
  putword((int)G);
  putword((int)H);
  putword((int)BL);
  putword(BP);
  putword((int)CL);
  putword((int)modptr);
  for (i = 0; i < LENHASH; i++) putword(hash[i]);
  for (i = 0; i < SYSWSIZE; i++) putword(syswords[i]);
  for (p = &modstk[0]; p <= modptr; p++) putword(*p);
  for (p = GORG; p <= G; p++) putword(*p);
  for (p = LORG; p <= CL+ARGOFF+2; p++) putword(*p);
  q = H;
  while ((p = (int *) *(q+FRELINOFF)) != NULL) q = p;
  putword((int)q);
  putword((int)H);
  for (p = HORG; p <= q; p++) putword(*p);
  for (p = TRORG; p <= TR; p++) putword(*p);
  fclose(image);
  return(TRUE);
}


/*
  Restore a work image from the file named by box b.
  A better way to do this is to do block writes into memory.
*/

restimage(b)
int b;
{
  register int i, *p, *q;
  char fn[64];
  boxtostring(b,fn,64);
#ifdef os370
  if ((image = fopen(fn,"r,binary")) == NULL) return(FALSE);
#else
  if ((image = fopen(fn,"r")) == NULL) return(FALSE);
#endif
  TR = (int *) getword();
  L = (int *) getword();
  G = (int *) getword();
  H = (int *) getword();
  BL = (int *) getword();
  BP = getword();
  CL = (int *) getword();
  modptr = (int *) getword();
  for (i = 0; i < LENHASH; i++) hash[i] = getword();
  for (i = 0; i < SYSWSIZE; i++) syswords[i] = getword();
  for (p = &modstk[0]; p <= modptr; p++) *p = getword();
  for (p = GORG; p <= G; p++) *p = getword();
  for (p = LORG; p <= CL+ARGOFF+2; p++) *p = getword();
  q = (int *) getword();
  H = (int *) getword();
  for (p = HORG; p <= q; p++) *p = getword();
  q = H;
  while ((p = (int *) *(q+FRELINOFF)) != NULL) q = p;
  *(q+FRECOUOFF) = TRORG - q;
  for (p = TRORG; p <= TR; p++) *p = getword();
  fclose(image);
  return(TRUE);
}


/* write a word on image.  code can be improved. */

static putword(i)
register int i;
{
  putc((i >> 24) & 0377,image);
  putc((i >> 16) & 0377,image);
  putc((i >>  8) & 0377,image);
  putc(        i & 0377,image);
}


/* read a word from image. code can be improved. */

static int getword()
{
  register int c,i;
  c = getc(image);
  if (c == EOF) return(c);
  c &= 0377;
  for (i = 0; i < 3; i++) c = (c << 8) | (getc(image) & 0377);
  return(c);
}
