/*
           ZIP TOP-LEVEL + RESIDENT COMPILER + DECOMPILER

                    W F Clocksin  20 Aug 82

This file is compiled, using the StandAlone compiler, into ZAP assembly
code.  The assembly code is then assembled by the ZAP assembler,
which installs all procedures and operators into module 'rootmodule'.
*/

/* declarations are compiled into ZAP pseudoinstructions */

?-zap([primitive,primflag,3,1,7]).
?-zap([primitive,primsee,1,2,7]).
?-zap([primitive,primtell,1,3,7]).
?-zap([primitive,get_file_status,6,4,0]).
?-zap([primitive,put_file_status,6,5,0]).
?-zap([primitive,seen,0,6,7]).
?-zap([primitive,told,0,7,7]).
?-zap([primitive,get0,1,8,7]).
?-zap([primitive,primput,1,9,7]).
?-zap([primitive,primcompare,3,10,0]).
?-zap([primitive,tokenread,3,11,7]).
?-zap([primitive,primcom12,0,12,0]).
?-zap([primitive,erase,1,13,7]).
?-zap([primitive,simpleterm,1,14,7]).
?-zap([primitive,tokenalpha,1,15,7]).
?-zap([primitive,primcom1,4,16,0]).
/* 17 vacant */
?-zap([primitive,primcom3,8,18,0]).
?-zap([primitive,primcom0,0,19,0]).
?-zap([primitive,primcom11,2,20,0]).
?-zap([primitive,tokenother,1,21,7]).
?-zap([primitive,get1,1,22,7]).
?-zap([primitive,putflush,1,23,7]).
/* 24 vacant */
?-zap([primitive,eraselast,0,25,7]).
/* 26 vacant */
?-zap([primitive,primcom9,1,27,0]).
?-zap([primitive,tokenput,2,28,6]).
?-zap([primitive,primcom10,1,29,0]).
/* 30 vacant */
?-zap([primitive,isop,6,31,6]).
?-zap([primitive,primcom8,3,32,7]).
?-zap([primitive,intfloat,2,33,7]).
/* 34-36 vacant */
?-zap([primitive,get,1,37,7]).
/* 38 vacant */
/* 39-41 vacant */
/* 42 vacant */
?-zap([primitive,statistics,2,43,7]).
/* 44-47 vacant */
?-zap([primitive,primread,5,48,0]).
?-zap([primitive,skip,1,49,7]).
?-zap([primitive,abort,0,50,7]).
?-zap([primitive,primvisa,3,51,0]).
?-zap([primitive,primimport,4,52,0]).
?-zap([primitive,primmodule,2,53,7]).
?-zap([primitive,primendmodule,1,54,7]).
?-zap([primitive,halt,0,55,7]).
?-zap([primitive,primlen,2,56,0]).
?-zap([primitive,primname,2,57,7]).
/* 58-59 vacant */
?-zap([primitive,char_class,2,60,7]).
?-zap([primitive,save,2,61,7]).
?-zap([primitive,restore,1,62,7]).

?-zap([visible,';',2]).
?-zap([visible,'->',2]).
?-zap([visible,',',2]).
?-zap([visible,'^',2]).
?-zap([visible,'\+',1]).
?-zap([visible,'@<',2]).
?-zap([visible,'@>',2]).
?-zap([visible,'@=<',2]).
?-zap([visible,'@>=',2]).
?-zap([visible,'<',2]).
?-zap([visible,'=',2]).
?-zap([visible,'=..',2]).
?-zap([visible,'=:=',2]).
?-zap([visible,'=<',2]).
?-zap([visible,'==',2]).
?-zap([visible,'=\=',2]).
?-zap([visible,'>',2]).
?-zap([visible,'>=',2]).
?-zap([visible,'\=',2]).
?-zap([visible,'\==',2]).
?-zap([updatable,'C',3]).
?-zap([visible,abolish,2]).
?-zap([visible,arg,3]).
?-zap([visible,assert,1]).
?-zap([visible,assert,2]).
?-zap([visible,asserta,1]).
?-zap([visible,asserta,2]).
?-zap([visible,assertz,1]).
?-zap([visible,assertz,2]).
?-zap([visible,atom,1]).
?-zap([visible,atomic,1]).
?-zap([visible,bagof,3]).
?-zap([updatable,break_handler,0]).
?-zap([visible,call,1]).
?-zap([visible,clause,2]).
?-zap([visible,clause,3]).
?-zap([visible,compare,3]).
?-zap([visible,compile,1]).
?-zap([visible,consult,1]).
?-zap([updatable,current_op,6]).
?-zap([visible,display,1]).
?-zap([visible,endmodule,1]).
?-zap([updatable,error_handler,2]).
?-zap([visible,fail,0]).
?-zap([visible,findall,3]).
?-zap([visible,findall,4]).
?-zap([visible,functor,3]).
?-zap([visible,import,2]).
?-zap([visible,integer,1]).
?-zap([visible,is,2]).
?-zap([visible,keysort,2]).
?-zap([visible,length,2]).
?-zap([visible,listing,2]).
?-zap([visible,module,1]).
?-zap([visible,name,2]).
?-zap([visible,nl,0]).
?-zap([visible,nonvar,1]).
?-zap([visible,not,1]).
?-zap([visible, numbervars,3]).
?-zap([visible,op,3]).
?-zap([updatable,portray,1]).
?-zap([visible,put,1]).
?-zap([visible,read,1]).
?-zap([visible,read,2]).
?-zap([visible,recorded,3]).
?-zap([visible,recorda,3]).
?-zap([visible,recordz,3]).
?-zap([visible,repeat,0]).
?-zap([visible,retract,1]).
?-zap([visible,save,1]).
?-zap([visible,see,1]).
?-zap([visible,seeing,1]).
?-zap([visible,setof,3]).
?-zap([visible,sort,2]).
?-zap([visible,succ,2]).
?-zap([visible,tab,1]).
?-zap([visible,tell,1]).
?-zap([visible,telling,1]).
?-zap([visible,tracing,2]).
?-zap([visible,true,0]).
?-zap([visible,unknown,2]).
?-zap([visible,var,1]).
?-zap([visible,visa,2]).
?-zap([visible,write,1]).
?-zap([visible,writedepth,2]).
?-zap([visible,writeq,1]).
?-zap([visible,writewidth,2]).


current_op((':-'),1199,1200,1199,xfx,infix).
current_op(('-->'),1199,1200,1199,xfx,infix).
current_op((':-'),1199,1200,_,fx,prefix).
current_op(('?-'),1199,1200,_,fx,prefix).
current_op((mode),1149,1150,_,fx,prefix).
current_op((public),1149,1150,_,fx,prefix).
current_op(';',1099,1100,1100,xfy,infix).
current_op('->',1049,1050,1050,xfy,infix).
current_op(',',999,1000,1000,xfy,infix).
current_op(not,900,900,_,fy,prefix).
current_op('\+',900,900,_,fy,prefix).
current_op(is,699,700,699,xfx,infix).
current_op('=',699,700,699,xfx,infix).
current_op('\=',699,700,699,xfx,infix).
current_op('<',699,700,699,xfx,infix).
current_op('>',699,700,699,xfx,infix).
current_op('=<',699,700,699,xfx,infix).
current_op('>=',699,700,699,xfx,infix).
current_op('=..',699,700,699,xfx,infix).
current_op('=:=',699,700,699,xfx,infix).
current_op('=\=',699,700,699,xfx,infix).
current_op('==',699,700,699,xfx,infix).
current_op('\==',699,700,699,xfx,infix).
current_op('@<',499,500,499,xfx,infix).
current_op('@>',499,500,499,xfx,infix).
current_op('@=<',499,500,499,xfx,infix).
current_op('@>=',499,500,499,xfx,infix).
current_op('+',499,500,_,fx,prefix).
current_op('-',499,500,_,fx,prefix).
current_op('\',499,500,_,fx,prefix).
current_op('+',500,500,499,yfx,infix).
current_op('-',500,500,499,yfx,infix).
current_op('/\',500,500,499,yfx,infix).
current_op('\/',500,500,499,yfx,infix).
current_op(xor,500,500,499,yfx,infix).
current_op('*',400,400,399,yfx,infix).
current_op('/',400,400,399,yfx,infix).
current_op('<<',400,400,399,yfx,infix).
current_op('>>',400,400,399,yfx,infix).
current_op(mod,299,300,299,xfx,infix).
current_op('^',199,200,200,xfy,infix).


/* entry from ZIP Machine Exception */

unknown_handler(P) :- unknown(fail,_), !, fail.
unknown_handler(P) :- unknown(trace,_), error_handler(54,P).

error_handler(N,I) :-
        tell(user),
	tokenput('Error:  '),
	error_message(N,M),
	tokenput(M),
	nl,
	error_culprit(I),
	nl,
	abort.

error_culprit(X) :- var(X), tokenput(X).
error_culprit('no-culprit').
error_culprit('host-culprit') :- tokenput('(host exception code)').
error_culprit(C) :- tokenput('Culprit:  '), write(C).


/* entry from ZIP User Interrupt */

break_handler :-
	seeing(S),
	telling(T),
	repeat,
	see(user),
	tell(user),
	tokenput('(Break) '),
	doquery(X),
	X == end_of_file,
	see(S),
	tell(T),
	!.

/* entry from ZIP Machine Startup */

start_handler :-
	tell(user),
        tokenput('ORION Prolog, Release 4.0'),
	nl,
	toplevel,
	halt.
start_handler :- abort.


/* user toplevel interface */

toplevel :- repeat, see(user), tell(user), doquery(X), X == end_of_file.

doquery(X) :-
	tokenput('?- '),
	read(X,Y),
	queryform(X),
	answer(Y),
	!.
doquery(no) :- tokenput(no), nl.

queryform(X) :- var(X), !, fail.
queryform(end_of_file) :- !.
queryform([H|T]) :-
	!,
	conlist(H),
	conlist(T).
queryform(X) :-
	statistics(T,I),
	call(X),
	statistics(T1,I1),
	put("("),
        I2 is I1 - I,
	tokenput(I2),
	put("/"),
        T2 is T1 - T,
	tokenput(T2),
	put(")"),
	nl.
queryform(_) :- fail.  /* to prevent LCO */

answer([]) :-
	!,
	see(user),
	tell(user),
	tokenput(yes),
	nl.
answer(X) :-
	see(user),
	tell(user),
	prbindings(X),
	nl,
	tokenput('More (y/n)? '),
	!,
	get(C),
	skip(10),
	C = 110.

prbindings([]) :- !.
prbindings([N=V|L]) :-
	tokenput(N),
	tokenput(' = '),
	write(V),
	nl,
	prbindings(L).


/* simple predicates defined by PIP */

true.

repeat.
repeat :- repeat.

name(X,Y) :- nonvar(Y), !, primname(X,Y).
name(X,Y) :- primname(X,L), L = Y.

/* flag hacks */

tracing(Old,New) :- primflag(2047,Old,New).  /* 2047 = 8'1777 */

unknown(Old,New) :- getunk(Old), putunk(New).

getunk(fail) :- primflag(128,0,0), !.
getunk(trace) :- primflag(128,128,128).

putunk(X) :- var(X), !.
putunk(fail) :- primflag(128,_,0).
putunk(trace) :- primflag(128,_,128).


/*
  Database Hacks.
  In assert, failure of assboth is used to undo bindings made by compiler.
  source/5 is metacalled so the current module is located and used (v. clever).
*/

assert(X) :- assertz(X).

asserta(X) :- legal_clause(X), assboth(X,1).
asserta(_).

assertz(X) :- legal_clause(X), assboth(X,0).
assertz(_).

assert(X,R) :- assertz(X,R).

asserta(X,_) :- legal_clause(X), assboth(X,1).
asserta(_,R) :- primcom9(R).

assertz(X,_) :- legal_clause(X), assboth(X,0).
assertz(_,R) :- primcom9(R).

assboth(X,N) :- expand(X,X1), doassert(X1,N,0), fail.
assboth(X,N) :-
	primcom8(F,A,R),
	dest_clause(X,H,B),
	compassunit('%source%'(F,A,H,B,[],R),N,1),
	fail.

recorda(K,T,_) :- recterm(K,T,1).
recorda(_,_,R) :- primcom8(_,_,R).

recordz(K,T,_) :- recterm(K,T,0).
recordz(_,_,R) :- primcom8(_,_,R).

recterm(K,T,N) :- functor(K,F,A), compassunit('%database%'(F,A,T),N,1), fail.

recorded(K,T,R) :- functor(K,F,A), call('%database%'(F,A,T)), primcom10(R).


abolish(F,A) :- call('%source%'(F,A,_,_,_,R)), eraselast, erase(R), fail.
abolish(_,_).

retract(X) :-
	!,
	dest_clause(X,H,B),
	functor(H,F,A),
	call('%source%'(F,A,H,B,_,R)),
	eraselast,
	erase(R).

clause(H,B,R) :- !, functor(H,F,A), call('%source%'(F,A,H,B,_,R)).

clause(H,B) :- !, functor(H,F,A), call('%source%'(F,A,H,B,_,_)).

listing(F,A) :- call('%source%'(F,A,H,B,V,_)), bindnames(V), writecl(H,B), fail.
listing(_,_).

bindnames([]) :- !.
bindnames([N='%varname%'(N)|L]) :- bindnames(L).


/* Control predicates.  Calls to 'call' open-code to callx. */

call(X) :- call(X).

'^'(X,P) :- call(P).

','(P,Q) :- call(P), call(Q).

'->'(P,Q) :- call(P), !, call(Q).

';'('->'(A,B),C) :- call(A), !, call(B).
';'('->'(A,B),C) :- !, call(C).

';'(P,_) :- call(P).
';'(_,Q) :- call(Q).

\+(P) :- call(P), !, fail.
\+(P).

forall(P,Q) :- call(A), \+(B), !, fail.
forall(A,B).

'\='(X,X) :- !, fail.
'\='(_,_).


/* O'Keefe not, setof, bagof */

not(G) :-
	free_var(G,[],[],V),
	V \== [],
	!,
	warning(39,G).
not(G) :- call(G), !, fail.
not(_).


free_var(T,B,V,[T|V]) :-
	var(T),
	term_free(B,T),
	list_free(V,T),
	!.
free_var(T,B,V,V) :- var(T), !.
free_var(T,B,O,N) :- explicit(T,B,NT,NB), !, free_var(NT,NB,O,N).
free_var(T,B,O,N) :- functor(T,_,A), free_var(A,T,B,O,N).

free_var(0,T,B,V,V) :- !.
free_var(N,T,B,O,NL) :-
	arg(N,T,A),
	free_var(A,B,O,Mid),
	succ(M,N),
	!,
	free_var(M,T,B,Mid,NL).

explicit('\+'(G),B,fail,B).
explicit(not(G),B,fail,B).
explicit(^(V,G),B,G,B+V).
explicit(setof(V,G,S),B,G-S,B+V).
explicit(bagof(V,G,S),B,G-S,B+V).

term_free(T,V) :- var(T), !, T \== V.
term_free(T,V) :- functor(T,_,N), term_free(N,T,V).

term_free(0,T,V) :- !.
term_free(N,T,V) :-
	arg(N,T,A),
	term_free(A,V),
	succ(M,N),
	!,
	term_free(M,T,V).

list_free([H|T],V) :- H \== V, !, list_free(T,V).
list_free([],_).

findall(T,G,L) :- save_inst(-T,G), list_inst([],L).

findall(T,G,S,L) :- save_inst(-T,G), list_inst(S,L).

setof(T,F,S) :- bagof(T,F,B), sort(B,S).

bagof(T,G,B) :-
	free_var(G,T,[],V),
	V \== [],
	!,
	K =.. ['.'|V],
	functor(K,'.',N),
	save_inst(K-T,G),
	list_inst(K,N,[],OG),
	keysort(OG,Gam),
	!,
	con_subset(Gam,K,Ans),
	B = Ans.
bagof(T,G,B) :-
	save_inst(-T,G),
	list_inst([],B),
	B \== [].

save_inst(T,G) :- recorda('.','-',_), call(G), recorda('.',T,_), fail.
save_inst(_,_).

list_inst(S,Total) :- recorded('.',T,R), erase(R), !, list_inst(T,S,Total).

list_inst('-',S,Total) :- !, Total = S.
list_inst(-T,S,Total) :- list_inst([T|S],Total).

list_inst(K,NV,OB,NB) :-
	recorded('.',T,R),
	erase(R),
	!,
	list_inst(T,K,NV,OB,NB).

list_inst('-',_,_,A,A) :- !.
list_inst(NK-T,K,NV,OB,NB) :-
	replace(NV,K,NK),
	!,
	list_inst(K,NV,[NK-T|OB],NB).

replace(0,_,_) :- !.
replace(N,OK,NK) :-
	arg(N,NK,A),
	nonvar(A),
	!,
	succ(M,N),
	replace(M,OK,NK).
replace(N,OK,NK) :-
	arg(N,OK,OV),
	arg(N,NK,OV),
	succ(M,N),
	replace(M,OK,NK).

con_subset([K-V|R],C,A) :-
	con_subset(R,K,L,M),
	con_subset(M,K,[V|L],C,A).

con_subset([K-V|R],C,[V|L],M) :-
	K == C,
	!,
	con_subset(R,C,L,M).
con_subset(M,_,[],M).

con_subset([],K,S,K,S) :- !.
con_subset(_,K,S,K,S).
con_subset(M,_,_,C,A) :- con_subset(M,C,A).



/* Surfacing of open-coded predicates for interpreter */

fail :- fail.
integer(X) :- integer(X).
atom(X) :- atom(X).
var(X) :- var(X).
nonvar(X) :- nonvar(X).
succ(X,Y) :- succ(X,Y).
arg(X,Y,Z) :- arg(X,Y,Z).
functor(X,Y,Z) :- functor(X,Y,Z).
'='(X,Y) :- X = Y.
atomic(X) :- atomic(X).
'=:='(X,Y) :- '=:='(X,Y).
'=\='(X,Y) :- '=\='(X,Y).
(X < Y) :- X < Y.
(X > Y) :- X > Y.
(X =< Y) :- X =< Y.
(X >= Y) :- X >= Y.

(X is Y) :- eval(Y,Z), X = Z, !.

eval(X,_) :- var(X), error_handler(41,X).
eval(X,X) :- integer(X), !.
eval(cputime,X) :- statistics(X,_).
eval(calls,X) :- statistics(_,X).
eval(+(X,Y),Z) :- !, Z is X + Y.
eval(-(X,Y),Z) :- !, Z is X - Y.
eval(*(X,Y),Z) :- !, Z is X * Y.
eval(/(X,Y),Z) :- !, Z is X / Y.
eval(mod(X,Y),Z) :- !, Z is X mod Y.
eval('/\'(X,Y),Z) :- Z is X /\ Y.
eval('\/'(X,Y),Z) :- !, Z is X \/ Y.
eval('\'(X),Z) :- !, Z is '\'(X).
eval(<<(X,Y),Z) :- Z is X << Y.
eval(>>(X,Y),Z) :- !, Z is X >> Y.
eval(-(X),Z) :- !, Z is -(X).
eval(+(X),Z) :- !, Z is X.
eval([X|_],X) :- !, integer(X).
eval(X,Y) :- error_handler(40,X).


/* term subsumption */

numbervars('_'(M),M,N) :- !, succ(M,N).
numbervars(A,M,M) :- atomic(A), !.
numbervars(T,M,N) :- functor(T,_,A), numbervars(0,A,T,M,N).

numbervars(A,A,_,N,N) :- !.
numbervars(Am,Ar,T,M,N) :-
	succ(Am,An),
	arg(An,T,A),
	numbervars(A,M,K),
	!,
	numbervars(An,Ar,T,K,N).


/* term comparison */

compare(C,X,Y) :- primcompare(X,Y,S), compare(S,C), !.

compare(0,'=').
compare(S,'<') :- S < 0.
compare(S,'>') :- S > 0.

'=='(X,Y) :- primcompare(X,Y,0).

'\=='(X,Y) :- primcompare(X,Y,0), !, fail.
'\=='(_,_).

'@<'(X,Y) :- primcompare(X,Y,S), S < 0.
'@>'(X,Y) :- primcompare(X,Y,S), S > 0.
'@=<'(X,Y) :- primcompare(X,Y,S), S =< 0.
'@>='(X,Y) :- primcompare(X,Y,S), S >= 0.


/* sorting and key sorting */

sort(L,R) :- length(L,N), sort(N,L,_,R1), R1=R.

sort(2,[X1|L1],L,R) :-
	!,
	comprises(L1,X2,L),
	compare(C,X1,X2),
	signswap(C,X1,X2,R).
sort(1,[X|L],L,[X]) :- !.
sort(0,L,L,[]) :- !.
sort(N,L1,L3,R) :-
	N1 is N >> 1,
	N2 is N - N1,
	sort(N1,L1,L2,R1),
	sort(N2,L2,L3,R2),
	merge(R1,R2,R).

signswap('<',A,B,[A,B]) :- !.
signswap('>',A,B,[B,A]) :- !.
signswap('=',_,B,[B]) :- !.

merge([],R,R) :- !.
merge(R,[],R) :- !.
merge(R1,R2,[Xm|R]) :-
	comprises(R1,X1,R1a),
	comprises(R2,X2,R2a),
	compare(C,X1,X2),
	signmerge(C,X1,X2,Xm,R1,R1a,R1m,R2,R2a,R2m),
	merge(R1m,R2m,R).

signmerge('<',X,_,X,_,R1,R1,R2,_,R2).
signmerge('>',_,X,X,R1,_,R1,_,R2,R2).
signmerge('=',X,_,X,_,R1,R1,_,R2,R2).

comprises([X|L],X,L).

keysort(L,R) :- length(L,N), keysort(N,L,_,R1), R=R1.

keysort(2,[X1|L1],L,R) :-
	!,
	comprises(L1,X2,L),
	compare_keys(C,X1,X2),
	keysignswap(C,X1,X2,R).

keysort(1,[X|L],L,[X]) :- !.
keysort(0,L,L,[]) :- !.
keysort(N,L1,L3,R) :-
	N1 is N >> 1,
	N2 is N - N1,
	keysort(N1,L1,L2,R1),
	keysort(N2,L2,L3,R2),
	keymerge(R1,R2,R).

keysignswap('>',A,B,[B,A]) :- !.
keysignswap(_,A,B,[A,B]).

keymerge([],R,R) :- !.
keymerge(R,[],R) :- !.
keymerge(R1,R2,[X|R]) :-
	comprises(R1,X1,R1a),
	comprises(R2,X2,R2a),
	compare_keys(C,X1,X2),
	keysignmerge(C,X1,X2,X,R1,R1a,R1m,R2,R2a,R2m),
	keymerge(R1m,R2m,R).

keysignmerge('>',_,X,X,R1,_,R1,_,R2,R2) :- !.
keysignmerge(_,X,_,X,_,R1,R1,R2,_,R2).

compare_keys(C,K1-X1,K2-X2) :- compare(C,K1,K2).


/* implementing various declarations */

op(_,_,[]) :- !.
op(P,T,[A|L]) :- !, oplegal(3,A), oplegal(1,P), primop(T,P,A), op(P,T,L).
op(P,T,A) :- oplegal(3,A), oplegal(1,P), primop(T,P,A).

oplegal(3,A) :- atom(A), !.
oplegal(3,A) :- error_handler(44,A).
oplegal(1,P) :- integer(P), P > 0, P =< 1200, !.
oplegal(1,P) :- error_handler(42,P).

primop(fx,P,A) :- succ(O,P), assop(A,O,P,_,fx,prefix).
primop(fy,P,A) :- assop(A,P,P,_,fy,prefix).
primop(xf,P,A) :- succ(O,P), assop(A,O,P,_,xf,postfix).
primop(yf,P,A) :- assop(A,P,P,_,yf,postfix).
primop(xfy,P,A) :- succ(O,P), assop(A,O,P,P,xfy,infix).
primop(xfx,P,A) :- succ(O,P), assop(A,O,P,O,xfx,infix).
primop(yfx,P,A) :- succ(Q,P), assop(A,P,P,Q,yfx,infix).
primop(T,P,A) :- error_handler(43,T).

assop(A,O,P,Q,T,F) :- call(current_op(A,O,P,Q,T,F)), eraselast, fail.
assop(A,O,P,Q,T,F) :- doassert(current_op(A,O,P,Q,T,F),0,0), fail.
assop(_,_,_,_,_,_).

visa(A,B) :- attrib(A,4,N), givproc(B,N).

attrib([],M,M) :- !.
attrib([W|T],N,M) :- keyword(W,V), !, N1 is N \/ V, attrib(T,N1,M).
attrib(W,N,M) :- keyword(W,V), !, M is N \/ V.
attrib(X,_,_) :- error_handler(56,X).

keyword(omni,1).
keyword(sacred,2).

givproc([],_) :- !.
givproc([F/A|T],M) :- modlegal1(F,A,M), !, primvisa(F,A,M), givproc(T,M).
givproc(F/A,M) :- modlegal1(F,A,M), !, primvisa(F,A,M).
givproc(X,M) :- error_handler(56,(X,M)).

import([],_) :- !.
import([F/A|T],M) :- modlegal2(F,A,M), !, doimport(F,A,M), import(T,M).
import(F/A,M) :- modlegal2(F,A,M), doimport(F,A,M).
import(X,M) :- error_handler(57,(X,M)).

doimport(F,A,M) :- primimport(F,A,M,E), imperr(E,F/A), !.

imperr(0,_) :- !.
imperr(N,C) :- error_handler(N,C).

modlegal1(F,A,N) :- atom(F), integer(A), integer(N).

modlegal2(F,A,M) :- atom(F), integer(A), atom(M).

module(X) :- primmodule(X,E), moderr(E,X), !.

moderr(0,C) :- !.
moderr(E,C) :- error_handler(E,C).

endmodule(X) :- primendmodule(X), !.
endmodule(X) :- error_handler(65,X).


/* list processing */

length(L,N) :- nonvar(L), !, primlen(L,N).
length(L,N) :- slowlen(L,N).

slowlen([],0) :- !.
slowlen([_|L],N) :- succ(N1,N), slowlen(L,N1).

'=..'(T,[F|A]) :- nonvar(T), !, functor(T,F,N), arglist(N,T,[],A).
'=..'(T,[F|A]) :- atom(F), !, primlen(A,N), functor(T,F,N), arglist(N,T,[],A).

arglist(0,T,L0,L0) :- !.
arglist(N,T,L0,L) :- arg(N,T,An), succ(N1,N), arglist(N1,T,[An|L0],L) .


/* assorted input/output */

see(X) :- primsee(X), !.
see(X) :- error_handler(35,X).

tell(X) :- primtell(X), !.
tell(X) :- error_handler(35,X).

seeing(X) :- get_file_status(1,X,_,_,_,_).

telling(X) :- get_file_status(0,X,_,_,_,_).

put(X) :- X1 is X, primput(X1).

nl :- primput(10).

tab(N) :- N1 is N, tabn(N1).

tabn(0) :- !.
tabn(N) :- primput(32), succ(N1,N), tabn(N1).

tokenput(X) :- tokenput(X,0).

tokenquote(X) :- tokenput(X,1).

save(X) :- save(X,_).

writedepth(X,Y) :- get_file_status(0,_,_,_,_,X), put_file_status(0,_,_,_,_,Y).

writewidth(X,Y) :- get_file_status(0,_,_,_,X,_), put_file_status(0,_,_,_,Y,_).

/* read(X) and read(X,Y) in separate file */

/* writecl(X), write(X), display(X), print(X), and writeq(X) in separate file */


/* consulting */

conlist([]) :- !.
conlist([HD|TL]) :- !, conlist(HD), conlist(TL).
conlist(X) :-
	consult(X),
	telling(F),
	tell(user),
	write(X),
	tokenput(' consulted.'),
	nl,
	tell(F).

consult(X) :-
	var(X),
	tokenput('argument of consult must be instantiated'),
	nl,
	!.
consult(user) :-
	!,
	seeing(I),
	see(user),
	repeat,
	tokenput(': '),
	read(T,V),
	process(T,V,0),
	seen,
	see(I),
	nl,
	!.
consult(F) :-
	seeing(I),
	see(F),
	repeat,
	read(T,V),
	process(T,V,0),
	seen,
	see(I),
	!.

compile([]) :- !.
compile([H|T]) :- compile(H), compile(T).
compile(F) :-
	seeing(I),
	see(F),
	repeat,
	read(T),
	process(T,[],1),
	seen,
	telling(O),
	tell(user),
	tokenput(F),
	tokenput(' compiled.'),
	nl,
	tell(O),
	see(I).


process(X,_,_) :- var(X), warning(48,X), !, fail.
process(end_of_file,_,_) :- !.
process(?-(X),_,_) :- !, pro_query(X), !, fail.
process(:-(X),_,_) :- !, pro_query(X), !, fail.
process(-->(LP,[]),_,_) :- !, g_head(LP,S,S,H), semiassert(H).
process(-->(LP,RP),V,_):-
	!,
	g_head(LP,S,SR,H),
	g_body(RP,S,SR,B1),
	g_tidy(B1,B),
	semiassert((H:-B)).
process(L,V,0) :- !, legal_clause(L), fullassert(L,V).
process(L,V,1) :- !, legal_clause(L), semiassert(L).

pro_query([H|T]) :- !, conlist(H), conlist(T).
pro_query(mode(X)) :- !.
pro_query(public(X)) :- !.
pro_query(X) :- !, call(X).

fullassert(C,_) :- expand(C,C1), doassert(C1,0,0), fail.
fullassert(C,V) :-
	primcom8(N,A,R),
	dest_clause(C,H,B),
	compassunit('%source%'(N,A,H,B,V,R),0,1),
	fail.

semiassert(C) :- expand(C,C1), doassert(C1,0,0), fail.


/* A Warning handler: like errors but called by Prolog rather than ZIP */

warning(N,G) :-
	telling(T),
	tell(user),
	tokenput('Warning:  '),
	error_message(N,M),
	tokenput(M),
	nl,
	tokenput('Culprit:  '),
	write(G),
	nl,
	get_file_status(1,F,L,C,_,_),
	read_info(F,L,C),
	nl,
	tell(T),
	!.	

read_info(user,_,_) :- !, tokenput('Type input again.').
read_info(F,L,C) :-
	tokenput(' in column '),
	tokenput(C),
	tokenput(' of line '),
	tokenput(L),
	tokenput(' of file '),
	tokenput(F).


/* Error messages for exceptions and syntax errors. */

error_message(1,'operator expected after expression').
error_message(2,'token or operator expected').
error_message(3,'expression expected').
error_message(4,'token cannot start an expression').
error_message(5,'comma or closing round bracket expected').
error_message(6,'vertical bar or closing square bracket expected').
error_message(7,'incorrect position for prefix operator').
error_message(8,'incorrect position for culprit').
error_message(35,'host will not permit file to be opened').
error_message(39,'free variables in Culprit in attempting to prove not(Culprit)').
error_message(40,'functor without arithmetic interpretation found within second argument of "is"').
error_message(41,'improper argument of arithmetic expression').
error_message(42,'improper first argument for "op"').
error_message(43,'improper second argument for "op"').
error_message(44,'improper third argument for "op"').
error_message(45,'illegal attempt to modify a sacred procedure').
error_message(46,'XR table overflow').
error_message(47,'emitcode table overflow').
error_message(48,'this term is not a valid clause').
error_message(51,'an integer is not a valid goal.  "fail" substituted.').
error_message(52,'unknown opcode generated (system error)').
error_message(54,'attempt to execute unknown procedure').
error_message(56,'improper visa specification').
error_message(57,'improper import specification').
error_message(59,'no such procedure is defined').
error_message(60,'procedure already declared visible in all modules').
error_message(61,'procedure already declared visible in this module').
error_message(62,'permission not granted to import this procedure').
error_message(63,'module already entered').
error_message(64,'modules nested too deeply').
error_message(65,'module-endmodule mismatch').
error_message(66,'global stack exhausted (resource limit)').
error_message(67,'heap space exhausted (resource limit)').
error_message(68,'trail space exhausted (resource limit)').
error_message(69,'local space exhausted').
error_message(70,'compiler detects unlikely goal').
error_message(71,'this clause will be ignored').
error_message(X,X).
